/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLTruncateRecord
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_TRUNCATE = "TRUNCATE";
    public static final String KEYWORD_RECORD = "RECORD";
    private Set<String> records = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLTruncateRecord parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLTruncateRecord.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_TRUNCATE)) {
                throw new OCommandSQLParsingException("Keyword TRUNCATE not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLTruncateRecord.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_RECORD)) {
                throw new OCommandSQLParsingException("Keyword RECORD not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLTruncateRecord.nextWord(this.parserText, this.parserText, oldPos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Expected one or more records. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            if (word.charAt(0) == '[') {
                OStringSerializerHelper.getCollection(this.parserText, oldPos, this.records);
            } else {
                this.records.add(word.toString());
            }
            if (this.records.isEmpty()) {
                throw new OCommandSQLParsingException("Missed record(s). Use " + this.getSyntax(), this.parserText, oldPos);
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.records.isEmpty()) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        int deleted = 0;
        ODatabaseDocumentInternal database = OCommandExecutorSQLTruncateRecord.getDatabase();
        for (String rec : this.records) {
            try {
                ORecordId rid = new ORecordId(rec);
                OStorageOperationResult<Boolean> result = database.getStorage().deleteRecord(rid, -1, 0, null);
                database.getLocalCache().deleteRecord(rid);
                if (!result.getResult().booleanValue()) continue;
                ++deleted;
            }
            catch (Throwable e) {
                throw OException.wrapException(new OCommandExecutionException("Error on executing command"), e);
            }
        }
        return deleted;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_QUICK_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public String getSyntax() {
        return "TRUNCATE RECORD <rid>*";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }
}

