/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cdi.jaxrsapi.runtime;

import java.util.Collection;
import javax.inject.Inject;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.wildfly.swarm.cdi.jaxrsapi.runtime.ClientServiceFactory;
import org.wildfly.swarm.client.jaxrs.ServiceClient;
import org.wildfly.swarm.jaxrs.JAXRSArchive;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;

@DeploymentScoped
public class ServiceClientProcessor
implements DeploymentProcessor {
    private final Archive<?> archive;
    private final IndexView index;

    @Inject
    public ServiceClientProcessor(Archive archive, IndexView index) {
        this.archive = archive;
        this.index = index;
    }

    public void process() {
        Collection serviceClients = this.index.getKnownDirectImplementors(DotName.createSimple((String)ServiceClient.class.getName()));
        serviceClients.forEach(info -> {
            String name = info.name().toString() + "_generated";
            String path = "WEB-INF/classes/" + name.replace('.', '/') + ".class";
            ((JAXRSArchive)this.archive.as(JAXRSArchive.class)).add((Asset)new ByteArrayAsset(ClientServiceFactory.createImpl(name, info)), path);
        });
    }
}

