/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.AbstractFlagAffectedCommand;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;

public class PutMapCommand
extends AbstractFlagAffectedCommand
implements WriteCommand,
MetadataAwareCommand,
RemoteLockCommand {
    public static final byte COMMAND_ID = 9;
    Map<Object, Object> map;
    CacheNotifier notifier;
    Metadata metadata;
    boolean isForwarded = false;
    private CommandInvocationId commandInvocationId;

    public PutMapCommand() {
    }

    public PutMapCommand(Map<?, ?> map, CacheNotifier notifier, Metadata metadata, Set<Flag> flags, CommandInvocationId commandInvocationId) {
        this.map = map;
        this.notifier = notifier;
        this.metadata = metadata;
        this.flags = flags;
        this.commandInvocationId = commandInvocationId;
    }

    public PutMapCommand(PutMapCommand command) {
        this.map = command.map;
        this.notifier = command.notifier;
        this.metadata = command.metadata;
        this.flags = command.flags;
        this.isForwarded = command.isForwarded;
        this.commandInvocationId = CommandInvocationId.generateIdFrom(command.commandInvocationId);
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutMapCommand(ctx, this);
    }

    @Override
    public Collection<Object> getKeysToLock() {
        return this.isForwarded ? Collections.emptyList() : Collections.unmodifiableCollection(this.map.keySet());
    }

    @Override
    public Object getKeyLockOwner() {
        return this.commandInvocationId;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return this.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    @Override
    public boolean hasSkipLocking() {
        return this.hasFlag(Flag.SKIP_LOCKING);
    }

    private MVCCEntry lookupMvccEntry(InvocationContext ctx, Object key) {
        return (MVCCEntry)ctx.lookupEntry(key);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        HashMap previousValues = new HashMap();
        for (Map.Entry<Object, Object> e : this.map.entrySet()) {
            Object key = e.getKey();
            MVCCEntry contextEntry = this.lookupMvccEntry(ctx, key);
            if (contextEntry == null) continue;
            Object newValue = e.getValue();
            Object previousValue = contextEntry.getValue();
            Metadata previousMetadata = contextEntry.getMetadata();
            previousValues.put(key, previousValue);
            if (contextEntry.isCreated()) {
                this.notifier.notifyCacheEntryCreated(key, newValue, this.metadata, true, ctx, this);
            } else {
                this.notifier.notifyCacheEntryModified(key, newValue, this.metadata, previousValue, previousMetadata, true, ctx, this);
            }
            contextEntry.setValue(newValue);
            Metadatas.updateMetadata(contextEntry, this.metadata);
            contextEntry.setChanged(true);
        }
        return previousValues;
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Object, Object> map) {
        this.map = map;
    }

    @Override
    public byte getCommandId() {
        return 9;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.map);
        output.writeObject(this.metadata);
        output.writeBoolean(this.isForwarded);
        output.writeObject(Flag.copyWithoutRemotableFlags(this.flags));
        output.writeObject(this.commandInvocationId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.map = (Map)input.readObject();
        this.metadata = (Metadata)input.readObject();
        this.isForwarded = input.readBoolean();
        this.flags = (Set)input.readObject();
        this.commandInvocationId = (CommandInvocationId)input.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutMapCommand that = (PutMapCommand)o;
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.map != null ? !this.map.equals(that.map) : that.map != null);
    }

    public int hashCode() {
        int result = this.map != null ? this.map.hashCode() : 0;
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PutMapCommand{map={");
        if (!this.map.isEmpty()) {
            Iterator<Map.Entry<Object, Object>> it = this.map.entrySet().iterator();
            int i = 0;
            while (true) {
                Map.Entry<Object, Object> e = it.next();
                sb.append(Util.toStr((Object)e.getKey())).append('=').append(Util.toStr((Object)e.getValue()));
                if (!it.hasNext()) break;
                if (i > 100) {
                    sb.append(" ...");
                    break;
                }
                sb.append(", ");
                ++i;
            }
        }
        sb.append("}, flags=").append(this.flags).append(", metadata=").append(this.metadata).append(", isForwarded=").append(this.isForwarded).append("}");
        return sb.toString();
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return this.map.keySet();
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean readsExistingValues() {
        return false;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean isForwarded() {
        return this.isForwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }
}

