/* Generated By:JJTree: Do not edit this line. OAlterClassStatement.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.metadata.schema.OClass;

import java.util.List;
import java.util.Map;

public class OAlterClassStatement extends OStatement {

  /**
   * the name of the class
   */
  protected OIdentifier       name;
  /**
   * the class property to be altered
   */
  public    OClass.ATTRIBUTES property;

  protected OIdentifier       identifierValue;
  protected List<OIdentifier> identifierListValue;
  protected Boolean           add;
  protected Boolean           remove;
  protected ONumber           numberValue;
  protected Boolean           booleanValue;
  public    OIdentifier       customKey;
  public    OExpression       customValue;

  // only to manage 'round-robin' as a cluster selection strategy (not a valid identifier)
  protected String customString;

  protected boolean unsafe;

  public OAlterClassStatement(int id) {
    super(id);
  }

  public OAlterClassStatement(OrientSql p, int id) {
    super(p, id);
  }

  @Override public void toString(Map<Object, Object> params, StringBuilder builder) {
    builder.append("ALTER CLASS ");
    name.toString(params, builder);
    builder.append(" " + property.name() + " ");
    switch (property) {
    case NAME:
    case SHORTNAME:
    case ADDCLUSTER:
    case REMOVECLUSTER:
    case DESCRIPTION:
    case ENCRYPTION:
      if (numberValue != null) {
        numberValue.toString(params, builder);//clusters only
      } else if (identifierValue != null) {
        identifierValue.toString(params, builder);
      } else {
        builder.append("null");
      }
      break;
    case CLUSTERSELECTION:
      if (identifierValue != null) {
        identifierValue.toString(params, builder);
      } else if (customString != null) {
        builder.append('\'').append(customString).append('\'');
      } else {
        builder.append("null");
      }
      break;
    case SUPERCLASS:
      if (Boolean.TRUE.equals(add)) {
        builder.append("+");
      } else if (Boolean.TRUE.equals(remove)) {
        builder.append("-");
      }
      if (identifierValue == null) {
        builder.append("null");
      } else {
        identifierValue.toString(params, builder);
      }
      break;
    case SUPERCLASSES:
      if (identifierListValue == null) {
        builder.append("null");
      } else {
        boolean first = true;
        for (OIdentifier ident : identifierListValue) {
          if (!first) {
            builder.append(", ");
          }
          ident.toString(params, builder);
          first = false;
        }
      }
      break;
    case OVERSIZE:
      numberValue.toString(params, builder);
      break;
    case STRICTMODE:
    case ABSTRACT:
      builder.append(booleanValue.booleanValue());
      break;
    case CUSTOM:
      customKey.toString(params, builder);
      if (customKey.getStringValue().equalsIgnoreCase("clear") && customValue == null) {
        //do nothing
      } else {
        builder.append("=");
        if (customValue == null) {
          builder.append("null");
        } else {
          customValue.toString(params, builder);
        }
      }
      break;
    }
    if (unsafe) {
      builder.append(" UNSAFE");
    }
  }
}
/* JavaCC - OriginalChecksum=4668bb1cd336844052df941f39bdb634 (do not edit this line) */
