package io.undertow.websockets.jsr;

import java.lang.IllegalStateException;
import io.undertow.websockets.WebSocketExtension;
import java.io.Serializable;
import javax.annotation.Generated;
import java.util.Set;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.String;
import io.undertow.util.PathTemplate;
import java.lang.Exception;
import java.lang.NoSuchMethodException;
import java.lang.Integer;
import java.lang.RuntimeException;
import io.undertow.websockets.jsr.FrameHandler.FrameType;
import javax.websocket.DeploymentException;
import java.lang.Class;
import java.util.List;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.InstantiationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2017-06-29T11:13:31+1000")
public class JsrWebSocketMessages_$bundle implements JsrWebSocketMessages,Serializable {
    private static final long serialVersionUID = 1L;
    protected JsrWebSocketMessages_$bundle() {}
    public static final JsrWebSocketMessages_$bundle INSTANCE = new JsrWebSocketMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final String pongMessageNotSupported = "UT003001: PongMessage not supported with MessageHandler.Async";
    protected String pongMessageNotSupported$str() {
        return pongMessageNotSupported;
    }
    @Override
    public final IllegalStateException pongMessageNotSupported() {
        final IllegalStateException result = new IllegalStateException(String.format(pongMessageNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sendStreamClosed = "UT003002: SendStream is closed";
    protected String sendStreamClosed$str() {
        return sendStreamClosed;
    }
    @Override
    public final IOException sendStreamClosed() {
        final IOException result = new IOException(String.format(sendStreamClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sendWriterClosed = "UT003003: SendWriter is closed";
    protected String sendWriterClosed$str() {
        return sendWriterClosed;
    }
    @Override
    public final IOException sendWriterClosed() {
        final IOException result = new IOException(String.format(sendWriterClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clientNotSupported = "UT003004: Client not supported";
    protected String clientNotSupported$str() {
        return clientNotSupported;
    }
    @Override
    public final DeploymentException clientNotSupported() {
        final DeploymentException result = new DeploymentException(String.format(clientNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerAlreadyRegistered = "UT003005: MessageHandler for type %s already registered";
    protected String handlerAlreadyRegistered$str() {
        return handlerAlreadyRegistered;
    }
    @Override
    public final IllegalStateException handlerAlreadyRegistered(final FrameType frameType) {
        final IllegalStateException result = new IllegalStateException(String.format(handlerAlreadyRegistered$str(), frameType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedFrameType = "UT003006: Unable to detect FrameType for clazz %s";
    protected String unsupportedFrameType$str() {
        return unsupportedFrameType;
    }
    @Override
    public final IllegalStateException unsupportedFrameType(final Class<? extends Object> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(unsupportedFrameType$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownHandlerType = "UT003007: Unable to detect MessageHandler type for %s";
    protected String unknownHandlerType$str() {
        return unknownHandlerType;
    }
    @Override
    public final IllegalStateException unknownHandlerType(final Class<? extends Object> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(unknownHandlerType$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownEncoderType = "UT003008: Unable to detect Encoder type for %s";
    protected String unknownEncoderType$str() {
        return unknownEncoderType;
    }
    @Override
    public final IllegalStateException unknownEncoderType(final Class<? extends Object> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(unknownEncoderType$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moreThanOneParameterOfType = "UT003009: More than one %s parameter for %s";
    protected String moreThanOneParameterOfType$str() {
        return moreThanOneParameterOfType;
    }
    @Override
    public final IllegalArgumentException moreThanOneParameterOfType(final Class<? extends Object> type, final Method method) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(moreThanOneParameterOfType$str(), type, method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterNotFound = "UT003010: No parameter of type %s found in method %s";
    protected String parameterNotFound$str() {
        return parameterNotFound;
    }
    @Override
    public final IllegalArgumentException parameterNotFound(final Class<? extends Object> type, final Method method) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(parameterNotFound$str(), type, method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moreThanOneAnnotation = "UT003011: More than one method is annotated with %s";
    protected String moreThanOneAnnotation$str() {
        return moreThanOneAnnotation;
    }
    @Override
    public final DeploymentException moreThanOneAnnotation(final Class<? extends Object> clazz) {
        final DeploymentException result = new DeploymentException(String.format(moreThanOneAnnotation$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameters = "UT003012: Method %s has invalid parameters at locations %s";
    protected String invalidParameters$str() {
        return invalidParameters;
    }
    @Override
    public final DeploymentException invalidParameters(final Method method, final Set<Integer> allParams) {
        final DeploymentException result = new DeploymentException(String.format(invalidParameters$str(), method, allParams));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineDecoderTypeFor = "UT003014: Could not determine decoder type for %s";
    protected String couldNotDetermineDecoderTypeFor$str() {
        return couldNotDetermineDecoderTypeFor;
    }
    @Override
    public final IllegalArgumentException couldNotDetermineDecoderTypeFor(final Class<? extends Object> decoderClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(couldNotDetermineDecoderTypeFor$str(), decoderClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDecoderAcceptedMessage = "UT003015: No decoder accepted message %s";
    protected String noDecoderAcceptedMessage$str() {
        return noDecoderAcceptedMessage;
    }
    @Override
    public final String noDecoderAcceptedMessage(final List<? extends javax.websocket.Decoder> decoders) {
        return String.format(noDecoderAcceptedMessage$str(), decoders);
    }
    private static final String cannotSendInMiddleOfFragmentedMessage = "UT003016: Cannot send in middle of fragmeneted message";
    protected String cannotSendInMiddleOfFragmentedMessage$str() {
        return cannotSendInMiddleOfFragmentedMessage;
    }
    @Override
    public final IllegalStateException cannotSendInMiddleOfFragmentedMessage() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotSendInMiddleOfFragmentedMessage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddEndpointAfterDeployment = "UT003017: Cannot add endpoint after deployment";
    protected String cannotAddEndpointAfterDeployment$str() {
        return cannotAddEndpointAfterDeployment;
    }
    @Override
    public final IllegalStateException cannotAddEndpointAfterDeployment() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotAddEndpointAfterDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineTypeOfDecodeMethodForClass = "UT003018: Could not determine type of decode method for class %s";
    protected String couldNotDetermineTypeOfDecodeMethodForClass$str() {
        return couldNotDetermineTypeOfDecodeMethodForClass;
    }
    @Override
    public final DeploymentException couldNotDetermineTypeOfDecodeMethodForClass(final Class<? extends javax.websocket.Decoder> decoder, final Exception e) {
        final DeploymentException result = new DeploymentException(String.format(couldNotDetermineTypeOfDecodeMethodForClass$str(), decoder), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineTypeOfEncodeMethodForClass = "UT003019: Could not determine type of encode method for class %s";
    protected String couldNotDetermineTypeOfEncodeMethodForClass$str() {
        return couldNotDetermineTypeOfEncodeMethodForClass;
    }
    @Override
    public final DeploymentException couldNotDetermineTypeOfEncodeMethodForClass(final Class<? extends javax.websocket.Encoder> encoder) {
        final DeploymentException result = new DeploymentException(String.format(couldNotDetermineTypeOfEncodeMethodForClass$str(), encoder));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String didNotImplementKnownDecoderSubclass = "UT003020: %s did not implement known decoder interface";
    protected String didNotImplementKnownDecoderSubclass$str() {
        return didNotImplementKnownDecoderSubclass;
    }
    @Override
    public final DeploymentException didNotImplementKnownDecoderSubclass(final Class<? extends javax.websocket.Decoder> decoder) {
        final DeploymentException result = new DeploymentException(String.format(didNotImplementKnownDecoderSubclass$str(), decoder));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classDoesNotHaveDefaultConstructor = "UT003021: %s does not have default constructor";
    protected String classDoesNotHaveDefaultConstructor$str() {
        return classDoesNotHaveDefaultConstructor;
    }
    @Override
    public final DeploymentException classDoesNotHaveDefaultConstructor(final Class<? extends Object> c, final NoSuchMethodException e) {
        final DeploymentException result = new DeploymentException(String.format(classDoesNotHaveDefaultConstructor$str(), c), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleEndpointsWithOverlappingPaths = "UT003023: Multiple endpoints with the same logical mapping %s and %s";
    protected String multipleEndpointsWithOverlappingPaths$str() {
        return multipleEndpointsWithOverlappingPaths;
    }
    @Override
    public final DeploymentException multipleEndpointsWithOverlappingPaths(final PathTemplate template, final PathTemplate existing) {
        final DeploymentException result = new DeploymentException(String.format(multipleEndpointsWithOverlappingPaths$str(), template, existing));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDeploy = "UT003024: Web socket deployment failed";
    protected String couldNotDeploy$str() {
        return couldNotDeploy;
    }
    @Override
    public final DeploymentException couldNotDeploy(final Exception e) {
        final DeploymentException result = new DeploymentException(String.format(couldNotDeploy$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConnectUntilDeploymentComplete = "UT003025: Cannot connect until deployment is complete";
    protected String cannotConnectUntilDeploymentComplete$str() {
        return cannotConnectUntilDeploymentComplete;
    }
    @Override
    public final IllegalStateException cannotConnectUntilDeploymentComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotConnectUntilDeploymentComplete$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAValidClientEndpointType = "UT003026: %s is not a valid client endpoint type";
    protected String notAValidClientEndpointType$str() {
        return notAValidClientEndpointType;
    }
    @Override
    public final DeploymentException notAValidClientEndpointType(final Class<? extends Object> type) {
        final DeploymentException result = new DeploymentException(String.format(notAValidClientEndpointType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classWasNotAnnotated = "UT003027: Class %s was not annotated with @ClientEndpoint or @ServerEndpoint";
    protected String classWasNotAnnotated$str() {
        return classWasNotAnnotated;
    }
    @Override
    public final DeploymentException classWasNotAnnotated(final Class<? extends Object> endpoint) {
        final DeploymentException result = new DeploymentException(String.format(classWasNotAnnotated$str(), endpoint));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotFindDecoderForType = "UT003028: Could not find decoder for type %s on method %s";
    protected String couldNotFindDecoderForType$str() {
        return couldNotFindDecoderForType;
    }
    @Override
    public final DeploymentException couldNotFindDecoderForType(final Class<? extends Object> param, final Method method) {
        final DeploymentException result = new DeploymentException(String.format(couldNotFindDecoderForType$str(), param, method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotFindMessageParameter = "UT003029: Could not find message parameter on method %s";
    protected String couldNotFindMessageParameter$str() {
        return couldNotFindMessageParameter;
    }
    @Override
    public final DeploymentException couldNotFindMessageParameter(final Method method) {
        final DeploymentException result = new DeploymentException(String.format(couldNotFindMessageParameter$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String receivedTextFrameButNoMethod = "UT003030: Received a text frame however endpoint does not have a method capable of handling it";
    protected String receivedTextFrameButNoMethod$str() {
        return receivedTextFrameButNoMethod;
    }
    @Override
    public final RuntimeException receivedTextFrameButNoMethod() {
        final RuntimeException result = new RuntimeException(String.format(receivedTextFrameButNoMethod$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String receivedBinaryFrameButNoMethod = "UT003031: Received a binary frame however endpoint does not have a method capable of handling it";
    protected String receivedBinaryFrameButNoMethod$str() {
        return receivedBinaryFrameButNoMethod;
    }
    @Override
    public final RuntimeException receivedBinaryFrameButNoMethod() {
        final RuntimeException result = new RuntimeException(String.format(receivedBinaryFrameButNoMethod$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParametersWithWrongAnnotation = "UT003033: Method %s has invalid parameters at locations %s. It looks like you may have accidentally used javax.ws.rs.PathParam instead of javax.websocket.server.PathParam";
    protected String invalidParametersWithWrongAnnotation$str() {
        return invalidParametersWithWrongAnnotation;
    }
    @Override
    public final DeploymentException invalidParametersWithWrongAnnotation(final Method method, final Set<Integer> allParams) {
        final DeploymentException result = new DeploymentException(String.format(invalidParametersWithWrongAnnotation$str(), method, allParams));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extensionWasNotPresentInClientHandshake = "UT003034: Server provided extension %s which was not in client supported extensions %s";
    protected String extensionWasNotPresentInClientHandshake$str() {
        return extensionWasNotPresentInClientHandshake;
    }
    @Override
    public final IOException extensionWasNotPresentInClientHandshake(final String e, final List<WebSocketExtension> supportedExtensions) {
        final IOException result = new IOException(String.format(extensionWasNotPresentInClientHandshake$str(), e, supportedExtensions));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionTimedOut = "UT003035: Connection timed out";
    protected String connectionTimedOut$str() {
        return connectionTimedOut;
    }
    @Override
    public final IOException connectionTimedOut() {
        final IOException result = new IOException(String.format(connectionTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerIsNull = "UT003036: SendHandler is null";
    protected String handlerIsNull$str() {
        return handlerIsNull;
    }
    @Override
    public final IllegalArgumentException handlerIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(handlerIsNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageInNull = "UT003037: Message is null";
    protected String messageInNull$str() {
        return messageInNull;
    }
    @Override
    public final IllegalArgumentException messageInNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(messageInNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageTooLarge = "UT003038: Message of size %s was larger than the maximum of %s";
    protected String messageTooLarge$str() {
        return messageTooLarge;
    }
    @Override
    public final IllegalArgumentException messageTooLarge(final int size, final int max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(messageTooLarge$str(), size, max));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateEndpoint = "UT003039: The container cannot find a suitable constructor to instantiate endpoint of type %s";
    protected String cannotInstantiateEndpoint$str() {
        return cannotInstantiateEndpoint;
    }
    @Override
    public final InstantiationException cannotInstantiateEndpoint(final Class<? extends Object> c) {
        final InstantiationException result = new InstantiationException(String.format(cannotInstantiateEndpoint$str(), c));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String endpointNotOfCorrectType = "UT003040: Annotated endpoint instance %s was not of correct type %s";
    protected String endpointNotOfCorrectType$str() {
        return endpointNotOfCorrectType;
    }
    @Override
    public final IllegalArgumentException endpointNotOfCorrectType(final Object instance, final Class expected) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(endpointNotOfCorrectType$str(), instance, expected));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String endpointDoesNotHaveAppropriateConstructor = "UT003041: Annotated endpoint %s does not have a no arg constructor, but is using a custom configurator. The custom configurator must create the instance.";
    protected String endpointDoesNotHaveAppropriateConstructor$str() {
        return endpointDoesNotHaveAppropriateConstructor;
    }
    @Override
    public final InstantiationException endpointDoesNotHaveAppropriateConstructor(final Class<? extends Object> endpoint) {
        final InstantiationException result = new InstantiationException(String.format(endpointDoesNotHaveAppropriateConstructor$str(), endpoint));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
