/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.metadata.security.OSecurityShared;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.storage.OStorageProxy;

public class OSecurityExternal
extends OSecurityShared {
    @Override
    public OUser authenticate(String iUsername, String iUserPassword) {
        OUser user = null;
        String dbName = this.getDatabase().getName();
        if (!(this.getDatabase().getStorage() instanceof OStorageProxy)) {
            if (Orient.instance().getSecurity() == null) {
                throw new OSecurityAccessException(dbName, "External Security System is null!");
            }
            String username = Orient.instance().getSecurity().authenticate(iUsername, iUserPassword);
            if (username != null) {
                user = this.getUser(username);
                if (user == null) {
                    throw new OSecurityAccessException(dbName, "User or password not valid for username: " + username + ", database: '" + dbName + "'");
                }
                if (user.getAccountStatus() != OSecurityUser.STATUSES.ACTIVE) {
                    throw new OSecurityAccessException(dbName, "User '" + username + "' is not active");
                }
            } else if (Orient.instance().getSecurity().isDefaultAllowed()) {
                user = super.authenticate(iUsername, iUserPassword);
            } else {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                throw new OSecurityAccessException(dbName, "User or password not valid for username: " + iUsername + ", database: '" + dbName + "'");
            }
        }
        return user;
    }

    @Override
    public OUser getUser(String username) {
        OUser user = null;
        if (Orient.instance().getSecurity() != null) {
            user = Orient.instance().getSecurity().getSystemUser(username, this.getDatabase().getName());
        }
        if (user == null) {
            user = super.getUser(username);
        }
        return user;
    }
}

