/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.opentracing;

import io.opentracing.contrib.web.servlet.filter.TracingFilter;
import java.util.Optional;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;

@DeploymentModule(name="org.wildfly.swarm.opentracing", slot="deployment")
@Configurable(value="swarm.opentracing")
public class OpenTracingFraction
implements Fraction<OpenTracingFraction> {
    @AttributeDocumentation(value="The servlet skip pattern as a Java compilable Pattern. Optional. Ex.: `/health-check`")
    @Configurable(value="swarm.opentracing.servlet.skipPattern")
    private Defaultable<String> servletSkipPattern = Defaultable.string((String)OpenTracingFraction.getDefault(TracingFilter.SKIP_PATTERN));

    public String getServletSkipPattern() {
        return (String)this.servletSkipPattern.get();
    }

    private static String getDefault(String key) {
        return Optional.ofNullable(System.getProperty(key, System.getenv(key))).orElse("");
    }
}

