/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.msgpack.io.Output;

public class StreamOutput
implements Output {
    private DataOutputStream out;

    public StreamOutput(OutputStream out) {
        this.out = new DataOutputStream(out);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void write(ByteBuffer bb) throws IOException {
        if (bb.hasArray()) {
            byte[] array = bb.array();
            int offset = bb.arrayOffset();
            this.out.write(array, offset, bb.remaining());
            bb.position(bb.limit());
        } else {
            byte[] buf = new byte[bb.remaining()];
            bb.get(buf);
            this.out.write(buf);
        }
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.out.write(v);
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeByteAndByte(byte b, byte v) throws IOException {
        this.out.write(b);
        this.out.write(v);
    }

    @Override
    public void writeByteAndShort(byte b, short v) throws IOException {
        this.out.write(b);
        this.out.writeShort(v);
    }

    @Override
    public void writeByteAndInt(byte b, int v) throws IOException {
        this.out.write(b);
        this.out.writeInt(v);
    }

    @Override
    public void writeByteAndLong(byte b, long v) throws IOException {
        this.out.write(b);
        this.out.writeLong(v);
    }

    @Override
    public void writeByteAndFloat(byte b, float v) throws IOException {
        this.out.write(b);
        this.out.writeFloat(v);
    }

    @Override
    public void writeByteAndDouble(byte b, double v) throws IOException {
        this.out.write(b);
        this.out.writeDouble(v);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

