/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.neo4j.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.wildfly.swarm.container.util.Messages;
import org.wildfly.swarm.neo4j.Neo4jFraction;
import org.wildfly.swarm.neo4j.runtime.Neo4jDriverInfo;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Pre
@ApplicationScoped
public class Neo4jCustomizer
implements Customizer {
    @Inject
    @Any
    Instance<Neo4jFraction> allDrivers;

    public void customize() throws Exception {
        this.customizeDrivers();
    }

    protected void customizeDrivers() {
        this.allDrivers.forEach(this::attemptInstallation);
    }

    protected void attemptInstallation(Neo4jFraction info) {
        Neo4jDriverInfo neo4jDBDriverInfo = new Neo4jDriverInfo();
        if (neo4jDBDriverInfo.detect(info)) {
            Messages.MESSAGES.autodetectedDriver(neo4jDBDriverInfo.name());
        }
    }
}

