/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.xml.ws.WebServiceException;

class FactoryFinder {
    private static final String JBOSS_JAXWS_CLIENT_MODULE = "org.jboss.ws.jaxws-client";

    FactoryFinder() {
    }

    private static Object newInstance(String className, ClassLoader classLoader) {
        try {
            Class spiClass = FactoryFinder.safeLoadClass(className, classLoader);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new WebServiceException("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new WebServiceException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Object find(String factoryId, String fallbackClassName) {
        ClassLoader classLoader;
        try {
            classLoader = FactoryFinder.getContextClassLoader();
        }
        catch (Exception x) {
            throw new WebServiceException(x.toString(), x);
        }
        String serviceId = "META-INF/services/" + factoryId;
        try {
            InputStream is = null;
            is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    return FactoryFinder.newInstance(factoryClassName, classLoader);
                }
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        try {
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxws.properties";
            File f = new File(configFile);
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                String factoryClassName = props.getProperty(factoryId);
                return FactoryFinder.newInstance(factoryClassName, classLoader);
            }
        }
        catch (Exception javah) {
            // empty catch block
        }
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException systemProp) {
            // empty catch block
        }
        ClassLoader moduleClassLoader = FactoryFinder.getModuleClassLoader();
        if (moduleClassLoader != null) {
            try {
                InputStream is = moduleClassLoader.getResourceAsStream(serviceId);
                if (is != null) {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String factoryClassName = rd.readLine();
                    rd.close();
                    if (factoryClassName != null && !"".equals(factoryClassName)) {
                        return FactoryFinder.newInstance(factoryClassName, moduleClassLoader);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fallbackClassName == null) {
            throw new WebServiceException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static ClassLoader getModuleClassLoader() throws WebServiceException {
        try {
            Object moduleLoader;
            final Class<?> moduleClass = Class.forName("org.jboss.modules.Module");
            Class<?> moduleIdentifierClass = Class.forName("org.jboss.modules.ModuleIdentifier");
            Class<?> moduleLoaderClass = Class.forName("org.jboss.modules.ModuleLoader");
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                moduleLoader = moduleClass.getMethod("getBootModuleLoader", new Class[0]).invoke(null, new Object[0]);
            } else {
                try {
                    moduleLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return moduleClass.getMethod("getBootModuleLoader", new Class[0]).invoke(null, new Object[0]);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (WebServiceException)pae.getException();
                }
            }
            Object moduleIdentifier = moduleIdentifierClass.getMethod("create", String.class).invoke(null, JBOSS_JAXWS_CLIENT_MODULE);
            final Object module = moduleLoaderClass.getMethod("loadModule", moduleIdentifierClass).invoke(moduleLoader, moduleIdentifier);
            if (sm == null) {
                return (ClassLoader)moduleClass.getMethod("getClassLoader", new Class[0]).invoke(module, new Object[0]);
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return (ClassLoader)moduleClass.getMethod("getClassLoader", new Class[0]).invoke(module, new Object[0]);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new WebServiceException(e);
        }
    }

    private static Class safeLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            int i;
            SecurityManager s = System.getSecurityManager();
            if (s != null && (i = className.lastIndexOf(46)) != -1) {
                s.checkPackageAccess(className.substring(0, i));
            }
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (SecurityException se) {
            if ("com.sun.xml.internal.ws.spi.ProviderImpl".equals(className)) {
                return Class.forName(className);
            }
            throw se;
        }
    }
}

