/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.AutoValue_ClientTracer;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorReporterAdapter;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.internal.Nullable;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import java.util.Random;
import zipkin.reporter.Reporter;

public abstract class ClientTracer
extends AnnotationSubmitter {
    public static Builder builder() {
        return new AutoValue_ClientTracer.Builder();
    }

    @Override
    abstract SpanAndEndpoint.ClientSpanAndEndpoint spanAndEndpoint();

    abstract Random randomGenerator();

    abstract Reporter<zipkin.Span> reporter();

    abstract Sampler traceSampler();

    @Override
    abstract AnnotationSubmitter.Clock clock();

    public void setClientSent() {
        this.submitStartAnnotation("cs");
    }

    public void setClientSent(Endpoint server) {
        this.submitAddress("sa", server);
        this.submitStartAnnotation("cs");
    }

    @Deprecated
    public void setClientSent(int ipv4, int port, @Nullable String serviceName) {
        if (serviceName == null) {
            serviceName = "unknown";
        }
        this.setClientSent(Endpoint.builder().ipv4(ipv4).port(port).serviceName(serviceName).build());
    }

    public void setClientReceived() {
        if (this.submitEndAnnotation("cr", this.reporter())) {
            this.spanAndEndpoint().state().setCurrentClientSpan(null);
        }
    }

    public SpanId startNewSpan(String requestName) {
        Boolean sample = this.spanAndEndpoint().state().sample();
        if (Boolean.FALSE.equals(sample)) {
            this.spanAndEndpoint().state().setCurrentClientSpan(null);
            return null;
        }
        SpanId newSpanId = this.getNewSpanId();
        if (sample == null && !this.traceSampler().isSampled(newSpanId.traceId)) {
            this.spanAndEndpoint().state().setCurrentClientSpan(null);
            return null;
        }
        Span newSpan = newSpanId.toSpan();
        newSpan.setName(requestName);
        this.spanAndEndpoint().state().setCurrentClientSpan(newSpan);
        return newSpanId;
    }

    private SpanId getNewSpanId() {
        ServerSpan serverSpan;
        Span parentSpan = this.spanAndEndpoint().state().getCurrentLocalSpan();
        if (parentSpan == null && (serverSpan = this.spanAndEndpoint().state().getCurrentServerSpan()) != null) {
            parentSpan = serverSpan.getSpan();
        }
        long newSpanId = this.randomGenerator().nextLong();
        SpanId.Builder builder = SpanId.builder().spanId(newSpanId);
        if (parentSpan == null) {
            return builder.build();
        }
        return builder.traceId(parentSpan.getTrace_id()).parentId(parentSpan.getId()).build();
    }

    ClientTracer() {
    }

    public static abstract class Builder {
        public Builder state(ServerClientAndLocalSpanState state) {
            return this.spanAndEndpoint(SpanAndEndpoint.ClientSpanAndEndpoint.create(state));
        }

        abstract Builder spanAndEndpoint(SpanAndEndpoint.ClientSpanAndEndpoint var1);

        public abstract Builder randomGenerator(Random var1);

        public abstract Builder reporter(Reporter<zipkin.Span> var1);

        @Deprecated
        public final Builder spanCollector(SpanCollector spanCollector) {
            return this.reporter(new SpanCollectorReporterAdapter(spanCollector));
        }

        public abstract Builder traceSampler(Sampler var1);

        public abstract Builder clock(AnnotationSubmitter.Clock var1);

        public abstract ClientTracer build();
    }
}

