/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.util.collections.Multimap;

public class Multimaps {
    private Multimaps() {
    }

    public static <K, V> Multimap<K, V> unmodifiableMultimap(Multimap<K, V> multimap) {
        if (multimap instanceof UnmodifiableMultimap) {
            return multimap;
        }
        return new UnmodifiableMultimap<K, V>(multimap);
    }

    static <V> Collection<V> unmodifiableValueCollection(Collection<V> values) {
        if (values instanceof Set) {
            return Collections.unmodifiableSet((Set)values);
        }
        if (values instanceof List) {
            return Collections.unmodifiableList((List)values);
        }
        return Collections.unmodifiableCollection(values);
    }

    static class UnmodifiableMultimap<K, V>
    implements Multimap<K, V> {
        private final Multimap<K, V> delegate;

        public UnmodifiableMultimap(Multimap<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Collection<V> get(K key) {
            if (this.delegate.containsKey(key)) {
                return Multimaps.unmodifiableValueCollection(this.delegate.get(key));
            }
            return Collections.emptyList();
        }

        @Override
        public boolean put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public Set<K> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<V> values() {
            return this.delegate.values();
        }

        @Override
        public Set<V> uniqueValues() {
            return this.delegate.uniqueValues();
        }

        @Override
        public boolean putAll(K key, Collection<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            return this.delegate.entrySet();
        }
    }
}

