/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.cga;

import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.cga.Circle;
import org.geolatte.geom.cga.NumericalMethods;

public class CircularArcLinearizer<P extends Position> {
    private final double threshold;
    private final P p0;
    private final P p1;
    private final P p2;
    private final Circle c;
    private final boolean isCounterClockwise;
    private final PositionSequenceBuilder<P> builder;

    public CircularArcLinearizer(P p0, P p1, P p2, double threshold) {
        if (p0 == null || p1 == null | p2 == null) {
            throw new IllegalArgumentException();
        }
        this.threshold = Math.abs(threshold);
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.c = new Circle((Position)p0, (Position)p1, (Position)p2, false);
        this.isCounterClockwise = NumericalMethods.isCounterClockwise(p0, p1, p2);
        this.builder = PositionSequenceBuilders.variableSized(p0.getClass());
    }

    public Circle getCircle() {
        return this.c;
    }

    public double getRadius() {
        return this.c.radius;
    }

    public PositionSequence<P> linearizeCircle() {
        double angleIncr = Math.acos((this.c.radius - this.threshold) / this.c.radius);
        PositionSequenceBuilder<?> builder = PositionSequenceBuilders.variableSized(this.p0.getClass());
        double theta0 = this.angleInDirection((Position)this.p0);
        double theta1 = this.angleInDirection((Position)this.p1);
        builder.add(this.p0);
        this.AddPointsBetweenPolarCoordinates(theta0, theta1, this.p0, this.p1, angleIncr, builder);
        builder.add(this.p1);
        this.AddPointsBetweenPolarCoordinates(theta1, theta0 + Math.PI * 2, this.p1, this.p0, angleIncr, builder);
        builder.add(this.p0);
        return builder.toPositionSequence();
    }

    public PositionSequence<P> linearize() {
        double theta0 = this.angleInDirection((Position)this.p0);
        double theta1 = this.angleInDirection((Position)this.p1);
        double theta2 = this.angleInDirection((Position)this.p2);
        double angleIncr = Math.acos((this.c.radius - this.threshold) / this.c.radius);
        PositionSequenceBuilder<?> builder = PositionSequenceBuilders.variableSized(this.p0.getClass());
        builder.add(this.p0);
        this.AddPointsBetweenPolarCoordinates(theta0, theta1, this.p0, this.p1, angleIncr, builder);
        builder.add(this.p1);
        this.AddPointsBetweenPolarCoordinates(theta1, theta2, this.p1, this.p2, angleIncr, builder);
        builder.add(this.p2);
        return builder.toPositionSequence();
    }

    private void AddPointsBetweenPolarCoordinates(double theta, double theta1, P p, P p1, double maxAngleIncr, PositionSequenceBuilder<P> builder) {
        int dim = ((Position)p).getCoordinateDimension();
        int steps = (int)Math.ceil(Math.abs(theta1 - theta) / maxAngleIncr);
        double angleIncr = Math.abs(theta1 - theta) / (double)steps;
        double[] incr = new double[dim - 2];
        for (int i = 0; i < incr.length; ++i) {
            incr[i] = (((Position)p1).getCoordinate(2 + i) - ((Position)p).getCoordinate(2 + i)) / (double)steps;
        }
        double sign = theta < theta1 ? 1.0 : -1.0;
        double[] buf = new double[dim];
        for (int i = 0; i < incr.length; ++i) {
            buf[2 + i] = ((Position)p).getCoordinate(2 + i);
        }
        double a = theta;
        for (int idx = 0; idx < steps - 1; ++idx) {
            buf[0] = this.c.x + this.c.radius * Math.cos(a += sign * angleIncr);
            buf[1] = this.c.y + this.c.radius * Math.sin(a);
            for (int i = 0; i < incr.length; ++i) {
                buf[2 + i] = buf[2 + i] + incr[i];
            }
            builder.add(buf);
        }
    }

    private double angleInDirection(Position p) {
        double x = p.getCoordinate(0) - this.c.x;
        double y = p.getCoordinate(1) - this.c.y;
        double theta = Math.atan2(y, x);
        if (this.isCounterClockwise) {
            return theta >= 0.0 ? theta : Math.PI * 2 + theta;
        }
        return theta <= 0.0 ? theta : theta - Math.PI * 2;
    }
}

