/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.cga;

import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;

public class NumericalMethods {
    public static double determinant(double a11, double a12, double a21, double a22) {
        TwoSum ts = new TwoSum(a11 * a22, -a12 * a21);
        return ts.estimate + ts.error;
    }

    public static double crossProduct(double x0, double y0, double x1, double y1) {
        return NumericalMethods.determinant(x0, x1, y0, y1);
    }

    public static double determinant(double a11, double a12, double a13, double a21, double a22, double a23, double a31, double a32, double a33) {
        TwoSum tl1 = new TwoSum(a11 * a22 * a33, a12 * a23 * a31);
        TwoSum tl2 = new TwoSum(tl1.estimate, a13 * a21 * a32);
        TwoSum tr1 = new TwoSum(a13 * a22 * a31, a12 * a21 * a33);
        TwoSum tr2 = new TwoSum(tr1.estimate, a11 * a23 * a32);
        TwoSum det = new TwoSum(tl2.estimate, -tr2.estimate);
        return det.estimate + det.error + tl1.error + tl2.error - tr1.error - tr2.error;
    }

    public static boolean isCounterClockwise(Position p0, Position p1, Position p2) {
        double det = NumericalMethods.deltaDeterminant(p0, p1, p2);
        if (det == 0.0) {
            throw new IllegalArgumentException("Positions are collinear in 2D");
        }
        return det > 0.0;
    }

    public static boolean isCounterClockwise(PositionSequence<?> positions) {
        if (positions.size() < 3) {
            return true;
        }
        Object p0 = positions.getPositionN(0);
        Object p1 = positions.getPositionN(1);
        Object p2 = positions.getPositionN(2);
        return NumericalMethods.isCounterClockwise(p0, p1, p2);
    }

    public static boolean collinear(Position p0, Position p1, Position p2) {
        double det = NumericalMethods.deltaDeterminant(p0, p1, p2);
        return det == 0.0;
    }

    private static double deltaDeterminant(Position p0, Position p1, Position p2) {
        double[] c0 = p0.toArray(null);
        double[] c1 = p1.toArray(null);
        double[] c2 = p2.toArray(null);
        return NumericalMethods.determinant(1.0, 1.0, 1.0, c0[0], c1[0], c2[0], c0[1], c1[1], c2[1]);
    }

    public static class TwoSum {
        final double estimate;
        final double error;

        public TwoSum(double a, double b) {
            double s = a + b;
            double a1 = s - b;
            double b1 = s - a1;
            double deltaA = a - a1;
            double deltaB = b - b1;
            this.estimate = s;
            this.error = deltaA + deltaB;
        }
    }
}

