/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.PostgisWktVariant;
import org.geolatte.geom.codec.UnsupportedConversionException;
import org.geolatte.geom.codec.WktEncoder;

class PostgisWktEncoder
implements WktEncoder {
    private static final PostgisWktVariant WKT_WORDS = new PostgisWktVariant();
    private static final int MAX_FRACTIONAL_DIGITS = 24;
    private static final DecimalFormatSymbols US_DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private final FieldPosition fp = new FieldPosition(0);
    private final NumberFormat formatter = new DecimalFormat("0.#", US_DECIMAL_FORMAT_SYMBOLS);
    private StringBuffer builder;
    private boolean inGeometryCollection = false;

    public PostgisWktEncoder() {
        this.formatter.setMaximumFractionDigits(24);
    }

    @Override
    public <P extends Position> String encode(Geometry<P> geometry) {
        this.prepare();
        this.addSridIfValid(geometry);
        this.addGeometry(geometry);
        return this.result();
    }

    private void prepare() {
        this.builder = new StringBuffer();
        this.inGeometryCollection = false;
    }

    private <P extends Position> void addSridIfValid(Geometry<P> geometry) {
        if (geometry.getSRID() < 1) {
            return;
        }
        this.builder.append("SRID=").append(geometry.getSRID()).append(";");
    }

    private <P extends Position> void addGeometry(Geometry<P> geometry) {
        this.addGeometryTag(geometry);
        this.addGeometryText(geometry);
    }

    private <P extends Position> void addGeometryText(Geometry<P> geometry) {
        if (geometry.isEmpty()) {
            this.addEmptyKeyword();
            return;
        }
        GeometryType type = geometry.getGeometryType();
        switch (type) {
            case POINT: 
            case LINE_STRING: 
            case LINEARRING: {
                this.addPointList(geometry.getPositions());
                break;
            }
            case POLYGON: {
                this.addStartList();
                this.addLinearRings((Polygon)geometry);
                this.addEndList();
                break;
            }
            case GEOMETRYCOLLECTION: {
                this.addStartList();
                this.addGeometries((GeometryCollection)geometry, true);
                this.addEndList();
                break;
            }
            case MULTIPOINT: 
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                this.addStartList();
                this.addGeometries((GeometryCollection)geometry, false);
                this.addEndList();
                break;
            }
            default: {
                throw new UnsupportedConversionException(String.format("Geometry type %s not supported.", new Object[]{type}));
            }
        }
    }

    private <P extends Position, G extends Geometry<P>> void addGeometries(GeometryCollection<P, G> collection, boolean withTag) {
        this.inGeometryCollection = true;
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            if (i > 0) {
                this.addDelimiter();
            }
            G geom = collection.getGeometryN(i);
            if (withTag) {
                this.addGeometry((Geometry<P>)geom);
                continue;
            }
            this.addGeometryText((Geometry<P>)geom);
        }
    }

    private <P extends Position> void addLinearRings(Polygon<P> geometry) {
        this.addRing(geometry.getExteriorRing());
        for (int i = 0; i < geometry.getNumInteriorRing(); ++i) {
            this.addDelimiter();
            this.addRing(geometry.getInteriorRingN(i));
        }
    }

    private <P extends Position> void addRing(LinearRing<P> ring) {
        this.addPointList(ring.getPositions());
    }

    private <P extends Position> void addPointList(PositionSequence<P> points) {
        this.addStartList();
        double[] coords = new double[points.getCoordinateDimension()];
        for (int i = 0; i < points.size(); ++i) {
            if (i > 0) {
                this.addDelimiter();
            }
            points.getCoordinates(i, coords);
            this.addPoint(coords);
        }
        this.addEndList();
    }

    private void addEndList() {
        this.builder.append(')');
    }

    private void addPoint(double[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            if (i > 0) {
                this.addWhitespace();
            }
            this.addNumber(coords[i]);
        }
    }

    private void addNumber(double value) {
        this.formatter.format(value, this.builder, this.fp);
    }

    private void addWhitespace() {
        this.builder.append(" ");
    }

    private void addDelimiter() {
        this.builder.append(",");
    }

    private void addStartList() {
        this.builder.append("(");
    }

    private void addEmptyKeyword() {
        this.builder.append(" EMPTY");
    }

    private void addGeometryTag(Geometry geometry) {
        if (this.inGeometryCollection) {
            this.builder.append(WKT_WORDS.wordFor(geometry, true));
        } else {
            this.builder.append(WKT_WORDS.wordFor(geometry, false));
        }
    }

    private String result() {
        return this.builder.toString();
    }
}

