/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.pool.EJBBoundPoolMetaData;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.Pool;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public abstract class AbstractPoolMergingProcessor<T extends EJBComponentDescription>
extends AbstractMergingProcessor<T> {
    public AbstractPoolMergingProcessor(Class<T> descriptionType) {
        super(descriptionType);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, T description) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation pool = clazz.getAnnotationInformation(Pool.class);
        if (pool == null) {
            return;
        }
        if (!pool.getClassLevelAnnotations().isEmpty()) {
            String poolName = (String)pool.getClassLevelAnnotations().get(0);
            if (poolName == null || poolName.trim().isEmpty()) {
                throw EjbLogger.ROOT_LOGGER.poolNameCannotBeEmptyString(((EJBComponentDescription)((Object)description)).getEJBName());
            }
            this.setPoolName(description, poolName);
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, T description) throws DeploymentUnitProcessingException {
        String ejbName = ((EJBComponentDescription)((Object)description)).getEJBName();
        EjbJarMetaData metaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (metaData == null) {
            return;
        }
        AssemblyDescriptorMetaData assemblyDescriptor = metaData.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        List pools = assemblyDescriptor.getAny(EJBBoundPoolMetaData.class);
        String poolName = null;
        if (pools != null) {
            for (EJBBoundPoolMetaData poolMetaData : pools) {
                if ("*".equals(poolMetaData.getEjbName()) && poolName == null) {
                    poolName = poolMetaData.getPoolName();
                    continue;
                }
                if (!ejbName.equals(poolMetaData.getEjbName())) continue;
                poolName = poolMetaData.getPoolName();
            }
        }
        if (poolName != null) {
            this.setPoolName(description, poolName);
        }
    }

    protected abstract void setPoolName(T var1, String var2);
}

