/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.deployment;

import java.security.AccessController;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.wildfly.swarm.microprofile.openapi.api.OpenApiDocument;
import org.wildfly.swarm.microprofile.openapi.api.models.OpenAPIImpl;

public class OpenApiServletContextListener
implements ServletContextListener {
    private final Config config;

    public OpenApiServletContextListener() {
        this(ConfigProvider.getConfig());
    }

    public OpenApiServletContextListener(Config config) {
        this.config = config;
    }

    public void contextInitialized(ServletContextEvent sce) {
        OpenApiDocument openApiDocument = OpenApiDocument.INSTANCE;
        openApiDocument.modelFromReader(this.modelFromReader());
        openApiDocument.filter(this.getFilter());
        openApiDocument.initialize();
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private OpenAPIImpl modelFromReader() {
        String readerClassName = this.config.getOptionalValue("mp.openapi.model.reader", String.class).orElse(null);
        if (readerClassName == null) {
            return null;
        }
        try {
            ClassLoader cl = OpenApiServletContextListener.getContextClassLoader();
            if (cl == null) {
                cl = OpenApiServletContextListener.class.getClassLoader();
            }
            Class<?> c = cl.loadClass(readerClassName);
            OASModelReader reader = (OASModelReader)c.newInstance();
            return (OpenAPIImpl)reader.buildModel();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private OASFilter getFilter() {
        String filterClassName = this.config.getOptionalValue("mp.openapi.filter", String.class).orElse(null);
        if (filterClassName == null) {
            return null;
        }
        try {
            ClassLoader cl = OpenApiServletContextListener.getContextClassLoader();
            if (cl == null) {
                cl = OpenApiServletContextListener.class.getClassLoader();
            }
            Class<?> c = cl.loadClass(filterClassName);
            return (OASFilter)c.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }
}

