/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.runtime;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.wildfly.swarm.microprofile.openapi.api.OpenApiConfig;
import org.wildfly.swarm.microprofile.openapi.api.OpenApiDocument;
import org.wildfly.swarm.microprofile.openapi.api.models.OpenAPIImpl;
import org.wildfly.swarm.microprofile.openapi.runtime.OpenApiAnnotationScanner;
import org.wildfly.swarm.microprofile.openapi.runtime.io.OpenApiParser;
import org.wildfly.swarm.microprofile.openapi.runtime.io.OpenApiSerializer;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;

@DeploymentScoped
public class OpenApiDeploymentProcessor
implements DeploymentProcessor {
    private static final Logger LOGGER = Logger.getLogger(OpenApiDeploymentProcessor.class);
    private static final String LISTENER_CLASS = "org.wildfly.swarm.microprofile.openapi.deployment.OpenApiServletContextListener";
    private final OpenApiConfig config;
    private final Archive archive;

    public OpenApiDeploymentProcessor(OpenApiConfig config, Archive archive) {
        this.config = config;
        this.archive = archive;
    }

    @Inject
    public OpenApiDeploymentProcessor(Archive archive) {
        this.config = OpenApiDeploymentProcessor.initConfigFromArchive(archive);
        this.archive = archive;
    }

    public void process() throws Exception {
        try {
            WARArchive warArchive = (WARArchive)this.archive.as(WARArchive.class);
            warArchive.findWebXmlAsset().addListener(LISTENER_CLASS);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register OpenAPI listener", e);
        }
        OpenApiDocument openApiDocument = OpenApiDocument.INSTANCE;
        openApiDocument.config(this.config);
        openApiDocument.modelFromStaticFile(this.modelFromStaticFile());
        openApiDocument.modelFromAnnotations(this.modelFromAnnotations());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OpenAPIImpl modelFromStaticFile() {
        OpenApiSerializer.Format format = OpenApiSerializer.Format.YAML;
        Node node = this.archive.get("/META-INF/openapi.yaml");
        if (node == null) {
            node = this.archive.get("/WEB-INF/classes/META-INF/openapi.yml");
        }
        if (node == null) {
            node = this.archive.get("/META-INF/openapi.yml");
        }
        if (node == null) {
            node = this.archive.get("/WEB-INF/classes/META-INF/openapi.yml");
        }
        if (node == null) {
            node = this.archive.get("/META-INF/openapi.json");
            format = OpenApiSerializer.Format.JSON;
        }
        if (node == null) {
            node = this.archive.get("/WEB-INF/classes/META-INF/openapi.json");
            format = OpenApiSerializer.Format.JSON;
        }
        if (node == null) {
            return null;
        }
        try (InputStream stream = node.getAsset().openStream();){
            OpenAPIImpl openAPIImpl = OpenApiParser.parse(stream, format);
            return openAPIImpl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private OpenAPIImpl modelFromAnnotations() {
        if (this.config.scanDisable()) {
            return null;
        }
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(this.config, this.archive);
        return scanner.scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OpenApiConfig initConfigFromArchive(Archive<?> archive) {
        ShrinkWrapClassLoader cl = new ShrinkWrapClassLoader(new Archive[]{archive});
        try {
            OpenApiConfig openApiConfig = new OpenApiConfig(ConfigProvider.getConfig((ClassLoader)cl));
            return openApiConfig;
        }
        finally {
            try {
                cl.close();
            }
            catch (IOException e) {
                LOGGER.warnv("Could not close ShrinkWrapClassLoader for {0}", (Object)archive.getName());
            }
        }
    }
}

