/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.runtime.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.wildfly.swarm.microprofile.openapi.runtime.io.JsonUtil;

public class OpenApiSerializer {
    private final OpenAPI oai;

    public static final String serialize(OpenAPI oai, Format format) throws IOException {
        try {
            OpenApiSerializer serializer = new OpenApiSerializer(oai);
            JsonNode tree = serializer.serialize();
            if (format == Format.JSON) {
                ObjectMapper mapper = new ObjectMapper();
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tree);
            }
            YAMLFactory factory = new YAMLFactory();
            factory.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
            factory.enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS);
            ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
            return mapper.writer().writeValueAsString((Object)tree);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public OpenApiSerializer(OpenAPI oai) {
        this.oai = oai;
    }

    private JsonNode serialize() {
        ObjectNode root = JsonUtil.objectNode();
        this.writeOpenAPI(root, this.oai);
        return root;
    }

    private void writeOpenAPI(ObjectNode node, OpenAPI model) {
        JsonUtil.stringProperty(node, "openapi", model.getOpenapi());
        this.writeInfo(node, model.getInfo());
        this.writeExternalDocumentation(node, model.getExternalDocs());
        this.writeServers(node, model.getServers());
        this.writeSecurity(node, model.getSecurity());
        this.writeTags(node, model.getTags());
        this.writePaths(node, model.getPaths());
        this.writeComponents(node, model.getComponents());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeInfo(ObjectNode parent, Info model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("info");
        JsonUtil.stringProperty(node, "title", model.getTitle());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        JsonUtil.stringProperty(node, "termsOfService", model.getTermsOfService());
        this.writeContact(node, model.getContact());
        this.writeLicense(node, model.getLicense());
        JsonUtil.stringProperty(node, "version", model.getVersion());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeContact(ObjectNode parent, Contact model) {
        if (model == null) {
            return;
        }
        ObjectNode node = JsonUtil.objectNode();
        parent.set("contact", (JsonNode)node);
        JsonUtil.stringProperty(node, "name", model.getName());
        JsonUtil.stringProperty(node, "url", model.getUrl());
        JsonUtil.stringProperty(node, "email", model.getEmail());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeLicense(ObjectNode parent, License model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("license");
        JsonUtil.stringProperty(node, "name", model.getName());
        JsonUtil.stringProperty(node, "url", model.getUrl());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeExternalDocumentation(ObjectNode parent, ExternalDocumentation model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("externalDocs");
        JsonUtil.stringProperty(node, "description", model.getDescription());
        JsonUtil.stringProperty(node, "url", model.getUrl());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeTags(ObjectNode node, List<Tag> tags) {
        if (tags == null) {
            return;
        }
        ArrayNode array = node.putArray("tags");
        for (Tag tag : tags) {
            ObjectNode tagNode = array.addObject();
            JsonUtil.stringProperty(tagNode, "name", tag.getName());
            JsonUtil.stringProperty(tagNode, "description", tag.getDescription());
            this.writeExternalDocumentation(tagNode, tag.getExternalDocs());
            this.writeExtensions(tagNode, (Extensible)tag);
        }
    }

    private void writeServers(ObjectNode node, List<Server> servers) {
        if (servers == null) {
            return;
        }
        ArrayNode array = node.putArray("servers");
        for (Server server : servers) {
            ObjectNode serverNode = array.addObject();
            this.writeServerToNode(serverNode, server);
        }
    }

    protected void writeServerToNode(ObjectNode node, Server model) {
        JsonUtil.stringProperty(node, "url", model.getUrl());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        this.writeServerVariables(node, model.getVariables());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeServerVariables(ObjectNode serverNode, ServerVariables variables) {
        if (variables == null) {
            return;
        }
        ObjectNode variablesNode = serverNode.putObject("variables");
        for (String varName : variables.keySet()) {
            this.writeServerVariable(variablesNode, varName, (ServerVariable)variables.get((Object)varName));
        }
        this.writeExtensions(variablesNode, (Extensible)variables);
    }

    private void writeServerVariable(ObjectNode parent, String variableName, ServerVariable model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(variableName);
        JsonUtil.stringProperty(node, "default", model.getDefaultValue());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        List enumeration = model.getEnumeration();
        if (enumeration != null) {
            ArrayNode enumArray = node.putArray("enum");
            for (String enumValue : enumeration) {
                enumArray.add(enumValue);
            }
        }
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeSecurity(ObjectNode parent, List<SecurityRequirement> security) {
        if (security == null) {
            return;
        }
        ArrayNode array = parent.putArray("security");
        for (SecurityRequirement securityRequirement : security) {
            ObjectNode srNode = array.addObject();
            for (String fieldName : securityRequirement.keySet()) {
                List values = (List)securityRequirement.get((Object)fieldName);
                ArrayNode valuesNode = srNode.putArray(fieldName);
                if (values == null) continue;
                for (String value : values) {
                    valuesNode.add(value);
                }
            }
        }
    }

    private void writePaths(ObjectNode parent, Paths paths) {
        if (paths == null) {
            return;
        }
        ObjectNode pathsNode = parent.putObject("paths");
        for (String pathName : paths.keySet()) {
            this.writePathItem(pathsNode, (PathItem)paths.get((Object)pathName), pathName);
        }
        this.writeExtensions(pathsNode, (Extensible)paths);
    }

    private void writePathItem(ObjectNode parent, PathItem model, String pathName) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(pathName);
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.stringProperty(node, "summary", model.getSummary());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        this.writeOperation(node, model.getGET(), "get");
        this.writeOperation(node, model.getPUT(), "put");
        this.writeOperation(node, model.getPOST(), "post");
        this.writeOperation(node, model.getDELETE(), "delete");
        this.writeOperation(node, model.getOPTIONS(), "options");
        this.writeOperation(node, model.getHEAD(), "head");
        this.writeOperation(node, model.getPATCH(), "patch");
        this.writeOperation(node, model.getTRACE(), "trace");
        this.writeParameterList(node, model.getParameters());
        this.writeServers(node, model.getServers());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeOperation(ObjectNode parent, Operation model, String method) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(method);
        this.writeStringArray(node, model.getTags(), "tags");
        JsonUtil.stringProperty(node, "summary", model.getSummary());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        this.writeExternalDocumentation(node, model.getExternalDocs());
        JsonUtil.stringProperty(node, "operationId", model.getOperationId());
        this.writeParameterList(node, model.getParameters());
        this.writeRequestBody(node, model.getRequestBody());
        this.writeAPIResponses(node, model.getResponses());
        this.writeCallbacks(node, model.getCallbacks());
        JsonUtil.booleanProperty(node, "deprecated", model.getDeprecated());
        this.writeSecurityRequirements(node, model.getSecurity());
        this.writeServers(node, model.getServers());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeRequestBody(ObjectNode parent, RequestBody model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("requestBody");
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        this.writeContent(node, model.getContent());
        JsonUtil.booleanProperty(node, "required", model.getRequired());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeContent(ObjectNode parent, Content model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("content");
        for (String name : model.keySet()) {
            this.writeMediaType(node, (MediaType)model.get((Object)name), name);
        }
    }

    private void writeMediaType(ObjectNode parent, MediaType model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        this.writeSchema(node, model.getSchema(), "schema");
        this.writeObject(node, "example", model.getExample());
        this.writeExamples(node, model.getExamples());
        this.writeEncodings(node, model.getEncoding());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeSchema(ObjectNode parent, Schema model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        this.writeSchemaToNode(node, model);
    }

    private void writeSchemaToNode(ObjectNode node, Schema model) {
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.stringProperty(node, "format", model.getFormat());
        JsonUtil.stringProperty(node, "title", model.getTitle());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        this.writeObject(node, "default", model.getDefaultValue());
        JsonUtil.bigDecimalProperty(node, "multipleOf", model.getMultipleOf());
        JsonUtil.bigDecimalProperty(node, "maximum", model.getMaximum());
        JsonUtil.booleanProperty(node, "exclusiveMaximum", model.getExclusiveMaximum());
        JsonUtil.bigDecimalProperty(node, "minimum", model.getMinimum());
        JsonUtil.booleanProperty(node, "exclusiveMinimum", model.getExclusiveMinimum());
        JsonUtil.intProperty(node, "maxLength", model.getMaxLength());
        JsonUtil.intProperty(node, "minLength", model.getMinLength());
        JsonUtil.stringProperty(node, "pattern", model.getPattern());
        JsonUtil.intProperty(node, "maxItems", model.getMaxItems());
        JsonUtil.intProperty(node, "minItems", model.getMinItems());
        JsonUtil.booleanProperty(node, "uniqueItems", model.getUniqueItems());
        JsonUtil.intProperty(node, "maxProperties", model.getMaxProperties());
        JsonUtil.intProperty(node, "minProperties", model.getMinProperties());
        this.writeStringArray(node, model.getRequired(), "required");
        this.writeObjectArray(node, model.getEnumeration(), "enum");
        JsonUtil.enumProperty(node, "type", model.getType());
        this.writeSchema(node, model.getItems(), "items");
        this.writeSchemaList(node, model.getAllOf(), "allOf");
        this.writeSchemas(node, model.getProperties(), "properties");
        if (model.getAdditionalProperties() instanceof Boolean) {
            JsonUtil.booleanProperty(node, "additionalProperties", (Boolean)model.getAdditionalProperties());
        } else {
            this.writeSchema(node, (Schema)model.getAdditionalProperties(), "additionalProperties");
        }
        JsonUtil.booleanProperty(node, "readOnly", model.getReadOnly());
        this.writeXML(node, model.getXml());
        this.writeExternalDocumentation(node, model.getExternalDocs());
        this.writeObject(node, "example", model.getExample());
        this.writeSchemaList(node, model.getOneOf(), "oneOf");
        this.writeSchemaList(node, model.getAnyOf(), "anyOf");
        this.writeSchema(node, model.getNot(), "not");
        this.writeDiscriminator(node, model.getDiscriminator());
        JsonUtil.booleanProperty(node, "nullable", model.getNullable());
        JsonUtil.booleanProperty(node, "writeOnly", model.getWriteOnly());
        JsonUtil.booleanProperty(node, "deprecated", model.getDeprecated());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeXML(ObjectNode parent, XML model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("xml");
        JsonUtil.stringProperty(node, "name", model.getName());
        JsonUtil.stringProperty(node, "namespace", model.getNamespace());
        JsonUtil.stringProperty(node, "prefix", model.getPrefix());
        JsonUtil.booleanProperty(node, "attribute", model.getAttribute());
        JsonUtil.booleanProperty(node, "wrapped", model.getWrapped());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeDiscriminator(ObjectNode parent, Discriminator model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("discriminator");
        JsonUtil.stringProperty(node, "propertyName", model.getPropertyName());
        this.writeStringMap(node, model.getMapping(), "mapping");
    }

    private void writeEncodings(ObjectNode parent, Map<String, Encoding> models) {
        if (models == null) {
            return;
        }
        ObjectNode node = parent.putObject("encoding");
        for (String name : models.keySet()) {
            Encoding encoding = models.get(name);
            this.writeEncoding(node, encoding, name);
        }
    }

    private void writeEncoding(ObjectNode parent, Encoding model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "contentType", model.getContentType());
        this.writeHeaders(node, model.getHeaders());
        JsonUtil.enumProperty(node, "style", model.getStyle());
        JsonUtil.booleanProperty(node, "explode", model.getExplode());
        JsonUtil.booleanProperty(node, "allowReserved", model.getAllowReserved());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeAPIResponses(ObjectNode parent, APIResponses model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("responses");
        this.writeAPIResponse(node, model.getDefault(), "default");
        for (String name : model.keySet()) {
            this.writeAPIResponse(node, (APIResponse)model.get((Object)name), name);
        }
    }

    private void writeAPIResponse(ObjectNode parent, APIResponse model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        this.writeHeaders(node, model.getHeaders());
        this.writeContent(node, model.getContent());
        this.writeLinks(node, model.getLinks());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeSecurityRequirements(ObjectNode parent, List<SecurityRequirement> models) {
        if (models == null) {
            return;
        }
        ArrayNode node = parent.putArray("security");
        for (SecurityRequirement securityRequirement : models) {
            ObjectNode secNode = node.addObject();
            this.writeSecurityRequirementToNode(secNode, securityRequirement);
        }
    }

    private void writeSecurityRequirementToNode(ObjectNode node, SecurityRequirement model) {
        if (model == null) {
            return;
        }
        for (String name : model.keySet()) {
            List scopes = (List)model.get((Object)name);
            this.writeStringArray(node, scopes, name);
        }
    }

    private void writeParameterList(ObjectNode parent, List<Parameter> models) {
        if (models == null) {
            return;
        }
        ArrayNode node = parent.putArray("parameters");
        for (Parameter model : models) {
            ObjectNode paramNode = node.addObject();
            this.writeParameterToNode(paramNode, model);
        }
    }

    private void writeParameterToNode(ObjectNode node, Parameter model) {
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.stringProperty(node, "name", model.getName());
        JsonUtil.enumProperty(node, "in", model.getIn());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        JsonUtil.booleanProperty(node, "required", model.getRequired());
        this.writeSchema(node, model.getSchema(), "schema");
        JsonUtil.booleanProperty(node, "allowEmptyValue", model.getAllowEmptyValue());
        JsonUtil.booleanProperty(node, "deprecated", model.getDeprecated());
        JsonUtil.enumProperty(node, "style", model.getStyle());
        JsonUtil.booleanProperty(node, "explode", model.getExplode());
        JsonUtil.booleanProperty(node, "allowReserved", model.getAllowReserved());
        this.writeObject(node, "example", model.getExample());
        this.writeExamples(node, model.getExamples());
        this.writeContent(node, model.getContent());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeComponents(ObjectNode parent, Components components) {
        if (components == null) {
            return;
        }
        ObjectNode node = parent.putObject("components");
        this.writeSchemas(node, components.getSchemas());
        this.writeResponses(node, components.getResponses());
        this.writeParameters(node, components.getParameters());
        this.writeExamples(node, components.getExamples());
        this.writeRequestBodies(node, components.getRequestBodies());
        this.writeHeaders(node, components.getHeaders());
        this.writeSecuritySchemes(node, components.getSecuritySchemes());
        this.writeLinks(node, components.getLinks());
        this.writeCallbacks(node, components.getCallbacks());
        this.writeExtensions(node, (Extensible)components);
    }

    private void writeSchemas(ObjectNode parent, Map<String, Schema> schemas) {
        this.writeSchemas(parent, schemas, "schemas");
    }

    private void writeSchemas(ObjectNode parent, Map<String, Schema> schemas, String propertyName) {
        if (schemas == null) {
            return;
        }
        ObjectNode schemasNode = parent.putObject(propertyName);
        for (String schemaName : schemas.keySet()) {
            this.writeSchema(schemasNode, schemas.get(schemaName), schemaName);
        }
    }

    private void writeSchemaList(ObjectNode parent, List<Schema> models, String propertyName) {
        if (models == null) {
            return;
        }
        ArrayNode schemasNode = parent.putArray(propertyName);
        for (Schema schema : models) {
            this.writeSchemaToNode(schemasNode.addObject(), schema);
        }
    }

    private void writeResponses(ObjectNode parent, Map<String, APIResponse> responses) {
        if (responses == null) {
            return;
        }
        ObjectNode responsesNode = parent.putObject("responses");
        for (String responseName : responses.keySet()) {
            this.writeAPIResponse(responsesNode, responses.get(responseName), responseName);
        }
    }

    private void writeParameters(ObjectNode parent, Map<String, Parameter> parameters) {
        if (parameters == null) {
            return;
        }
        ObjectNode parametersNode = parent.putObject("parameters");
        for (String parameterName : parameters.keySet()) {
            this.writeParameter(parametersNode, parameters.get(parameterName), parameterName);
        }
    }

    private void writeParameter(ObjectNode parent, Parameter model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        this.writeParameterToNode(node, model);
    }

    private void writeExamples(ObjectNode parent, Map<String, Example> examples) {
        if (examples == null) {
            return;
        }
        ObjectNode examplesNode = parent.putObject("examples");
        for (String exampleName : examples.keySet()) {
            this.writeExample(examplesNode, examples.get(exampleName), exampleName);
        }
    }

    private void writeExample(ObjectNode parent, Example model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.stringProperty(node, "summary", model.getSummary());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        this.writeObject(node, "value", model.getValue());
        JsonUtil.stringProperty(node, "externalValue", model.getExternalValue());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeRequestBodies(ObjectNode parent, Map<String, RequestBody> requestBodies) {
        if (requestBodies == null) {
            return;
        }
        ObjectNode requestBodiesNode = parent.putObject("requestBodies");
        for (String requestBodyName : requestBodies.keySet()) {
            this.writeRequestBody(requestBodiesNode, requestBodies.get(requestBodyName), requestBodyName);
        }
    }

    private void writeRequestBody(ObjectNode parent, RequestBody model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        this.writeContent(node, model.getContent());
        JsonUtil.booleanProperty(node, "required", model.getRequired());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeHeaders(ObjectNode parent, Map<String, Header> headers) {
        if (headers == null) {
            return;
        }
        ObjectNode headersNode = parent.putObject("headers");
        for (String headerName : headers.keySet()) {
            this.writeHeader(headersNode, headers.get(headerName), headerName);
        }
    }

    private void writeHeader(ObjectNode parent, Header model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        JsonUtil.booleanProperty(node, "required", model.getRequired());
        JsonUtil.booleanProperty(node, "deprecated", model.getDeprecated());
        JsonUtil.booleanProperty(node, "allowEmptyValue", model.getAllowEmptyValue());
        JsonUtil.enumProperty(node, "style", model.getStyle());
        JsonUtil.booleanProperty(node, "explode", model.getExplode());
        this.writeSchema(node, model.getSchema(), "schema");
        this.writeObject(node, "example", model.getExample());
        this.writeExamples(node, model.getExamples());
        this.writeContent(node, model.getContent());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeSecuritySchemes(ObjectNode parent, Map<String, SecurityScheme> securitySchemes) {
        if (securitySchemes == null) {
            return;
        }
        ObjectNode securitySchemesNode = parent.putObject("securitySchemes");
        for (String securitySchemeName : securitySchemes.keySet()) {
            this.writeSecurityScheme(securitySchemesNode, securitySchemes.get(securitySchemeName), securitySchemeName);
        }
    }

    private void writeSecurityScheme(ObjectNode parent, SecurityScheme model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.enumProperty(node, "type", model.getType());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        JsonUtil.stringProperty(node, "name", model.getName());
        JsonUtil.enumProperty(node, "in", model.getIn());
        JsonUtil.stringProperty(node, "scheme", model.getScheme());
        JsonUtil.stringProperty(node, "bearerFormat", model.getBearerFormat());
        this.writeOAuthFlows(node, model.getFlows());
        JsonUtil.stringProperty(node, "openIdConnectUrl", model.getOpenIdConnectUrl());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeOAuthFlows(ObjectNode parent, OAuthFlows model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("flows");
        this.writeOAuthFlow(node, model.getImplicit(), "implicit");
        this.writeOAuthFlow(node, model.getPassword(), "password");
        this.writeOAuthFlow(node, model.getClientCredentials(), "clientCredentials");
        this.writeOAuthFlow(node, model.getAuthorizationCode(), "authorizationCode");
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeOAuthFlow(ObjectNode parent, OAuthFlow model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "authorizationUrl", model.getAuthorizationUrl());
        JsonUtil.stringProperty(node, "tokenUrl", model.getTokenUrl());
        JsonUtil.stringProperty(node, "refreshUrl", model.getRefreshUrl());
        this.writeStringMap(node, (Map<String, String>)model.getScopes(), "scopes");
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeLinks(ObjectNode parent, Map<String, Link> links) {
        if (links == null) {
            return;
        }
        ObjectNode linksNode = parent.putObject("links");
        for (String linkName : links.keySet()) {
            this.writeLink(linksNode, links.get(linkName), linkName);
        }
    }

    private void writeLink(ObjectNode parent, Link model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.stringProperty(node, "operationRef", model.getOperationRef());
        JsonUtil.stringProperty(node, "operationId", model.getOperationId());
        this.writeLinkParameters(node, model.getParameters());
        this.writeObject(node, "requestBody", model.getRequestBody());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        this.writeServer(node, model.getServer());
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeLinkParameters(ObjectNode parent, Map<String, Object> parameters) {
        if (parameters == null) {
            return;
        }
        ObjectNode node = parent.putObject("parameters");
        for (String name : parameters.keySet()) {
            this.writeObject(node, name, parameters.get(name));
        }
    }

    private void writeServer(ObjectNode parent, Server model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("server");
        this.writeServerToNode(node, model);
    }

    private void writeCallbacks(ObjectNode parent, Map<String, Callback> callbacks) {
        if (callbacks == null) {
            return;
        }
        ObjectNode callbacksNode = parent.putObject("callbacks");
        for (String callbackName : callbacks.keySet()) {
            this.writeCallback(callbacksNode, callbacks.get(callbackName), callbackName);
        }
    }

    private void writeCallback(ObjectNode parent, Callback model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        for (String pathItemName : model.keySet()) {
            this.writePathItem(node, (PathItem)model.get((Object)pathItemName), pathItemName);
        }
        this.writeExtensions(node, (Extensible)model);
    }

    private void writeExtensions(ObjectNode node, Extensible model) {
        Map extensions = model.getExtensions();
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        for (Map.Entry entry : extensions.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.writeObject(node, key, value);
        }
    }

    private void writeStringArray(ObjectNode parent, List<String> models, String propertyName) {
        if (models == null) {
            return;
        }
        ArrayNode node = parent.putArray(propertyName);
        for (String model : models) {
            node.add(model);
        }
    }

    private void writeObjectArray(ObjectNode parent, List<Object> models, String propertyName) {
        if (models == null) {
            return;
        }
        ArrayNode node = parent.putArray(propertyName);
        for (Object model : models) {
            this.addObject(node, model);
        }
    }

    private void writeStringMap(ObjectNode parent, Map<String, String> models, String propertyName) {
        if (models == null) {
            return;
        }
        ObjectNode node = parent.putObject(propertyName);
        for (String name : models.keySet()) {
            String value = models.get(name);
            node.put(name, value);
        }
    }

    protected void writeObject(ObjectNode node, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            node.put(key, (String)value);
        } else if (value instanceof JsonNode) {
            node.set(key, (JsonNode)value);
        } else if (value instanceof BigDecimal) {
            node.put(key, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            node.put(key, new BigDecimal((BigInteger)value));
        } else if (value instanceof Boolean) {
            node.put(key, (Boolean)value);
        } else if (value instanceof Double) {
            node.put(key, (Double)value);
        } else if (value instanceof Float) {
            node.put(key, (Float)value);
        } else if (value instanceof Integer) {
            node.put(key, (Integer)value);
        } else if (value instanceof Long) {
            node.put(key, (Long)value);
        } else if (value instanceof List) {
            ArrayNode array = node.putArray(key);
            List values = (List)value;
            for (Object valueItem : values) {
                this.addObject(array, valueItem);
            }
        } else if (value instanceof Map) {
            ObjectNode objNode = node.putObject(key);
            Map values = (Map)value;
            for (Map.Entry entry : values.entrySet()) {
                String propertyName = (String)entry.getKey();
                this.writeObject(objNode, propertyName, entry.getValue());
            }
        } else {
            node.put(key, (String)null);
        }
    }

    private void addObject(ArrayNode node, Object value) {
        if (value instanceof String) {
            node.add((String)value);
        } else if (value instanceof JsonNode) {
            node.add((JsonNode)value);
        } else if (value instanceof BigDecimal) {
            node.add((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            node.add(new BigDecimal((BigInteger)value));
        } else if (value instanceof Boolean) {
            node.add((Boolean)value);
        } else if (value instanceof Double) {
            node.add((Double)value);
        } else if (value instanceof Float) {
            node.add((Float)value);
        } else if (value instanceof Integer) {
            node.add((Integer)value);
        } else if (value instanceof Long) {
            node.add((Long)value);
        } else if (value instanceof List) {
            ArrayNode array = node.addArray();
            List values = (List)value;
            for (Object valueItem : values) {
                this.addObject(array, valueItem);
            }
        } else if (value instanceof Map) {
            ObjectNode objNode = node.addObject();
            Map values = (Map)value;
            for (Map.Entry entry : values.entrySet()) {
                String propertyName = (String)entry.getKey();
                this.writeObject(objNode, propertyName, entry.getValue());
            }
        } else {
            node.add((String)null);
        }
    }

    public static enum Format {
        JSON("application/json"),
        YAML("application/yaml");

        private final String mimeType;

        private Format(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }
}

