/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.cxf.common.jaxb.JAXBContextCache;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.realm.UsernameTokenRealmCodec;
import org.apache.cxf.sts.token.validator.DefaultSubjectRoleParser;
import org.apache.cxf.sts.token.validator.SubjectRoleParser;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.sts.provider.model.ObjectFactory;
import org.apache.cxf.ws.security.sts.provider.model.secext.UsernameTokenType;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.bsp.BSPEnforcer;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.CustomTokenPrincipal;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UsernameTokenValidator
implements TokenValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(UsernameTokenValidator.class);
    private Validator validator = new org.apache.wss4j.dom.validate.UsernameTokenValidator();
    private UsernameTokenRealmCodec usernameTokenRealmCodec;
    private SubjectRoleParser roleParser = new DefaultSubjectRoleParser();

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setUsernameTokenRealmCodec(UsernameTokenRealmCodec usernameTokenRealmCodec) {
        this.usernameTokenRealmCodec = usernameTokenRealmCodec;
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget) {
        return this.canHandleToken(validateTarget, null);
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget, String realm) {
        return validateTarget.getToken() instanceof UsernameTokenType;
    }

    @Override
    public TokenValidatorResponse validateToken(TokenValidatorParameters tokenParameters) {
        LOG.fine("Validating UsernameToken");
        STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
        Crypto sigCrypto = stsProperties.getSignatureCrypto();
        CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
        RequestData requestData = new RequestData();
        requestData.setSigVerCrypto(sigCrypto);
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        requestData.setWssConfig(wssConfig);
        requestData.setCallbackHandler(callbackHandler);
        requestData.setMsgContext(tokenParameters.getMessageContext());
        TokenValidatorResponse response = new TokenValidatorResponse();
        ReceivedToken validateTarget = tokenParameters.getToken();
        validateTarget.setState(ReceivedToken.STATE.INVALID);
        response.setToken(validateTarget);
        if (!validateTarget.isUsernameToken()) {
            return response;
        }
        UsernameTokenType usernameTokenType = (UsernameTokenType)validateTarget.getToken();
        Element usernameTokenElement = null;
        try {
            HashSet<Class> classes = new HashSet<Class>();
            classes.add(ObjectFactory.class);
            classes.add(org.apache.cxf.ws.security.sts.provider.model.wstrust14.ObjectFactory.class);
            JAXBContextCache.CachedContextAndSchemas cache = JAXBContextCache.getCachedContextAndSchemas(classes, null, null, null, (boolean)false);
            JAXBContext jaxbContext = cache.getContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            Document doc = DOMUtils.createDocument();
            Element rootElement = doc.createElement("root-element");
            JAXBElement tokenType = new JAXBElement(QNameConstants.USERNAME_TOKEN, UsernameTokenType.class, (Object)usernameTokenType);
            marshaller.marshal((Object)tokenType, (Node)rootElement);
            usernameTokenElement = (Element)rootElement.getFirstChild();
        }
        catch (JAXBException ex) {
            LOG.log(Level.WARNING, "", ex);
            return response;
        }
        try {
            boolean allowNamespaceQualifiedPasswordTypes = requestData.isAllowNamespaceQualifiedPasswordTypes();
            UsernameToken ut = new UsernameToken(usernameTokenElement, allowNamespaceQualifiedPasswordTypes, new BSPEnforcer());
            response.setPrincipal((Principal)new CustomTokenPrincipal(ut.getName()));
            if (ut.getPassword() == null) {
                return response;
            }
            int hash = ut.hashCode();
            SecurityToken secToken = null;
            if (tokenParameters.getTokenStore() != null && (secToken = tokenParameters.getTokenStore().getToken(Integer.toString(hash))) != null && (secToken.getTokenHash() != hash || secToken.isExpired())) {
                secToken = null;
            }
            Principal principal = null;
            if (secToken == null) {
                Credential credential = new Credential();
                credential.setUsernametoken(ut);
                credential = this.validator.validate(credential, requestData);
                principal = credential.getPrincipal();
                if (credential.getSubject() != null && this.roleParser != null) {
                    Set<Principal> roles = this.roleParser.parseRolesFromSubject(principal, credential.getSubject());
                    response.setRoles(roles);
                }
            }
            if (principal == null) {
                principal = this.createPrincipal(ut.getName(), ut.getPassword(), ut.getPasswordType(), ut.getNonce(), ut.getCreated());
            }
            String tokenRealm = null;
            if (this.usernameTokenRealmCodec != null) {
                String cachedRealm;
                Map props;
                tokenRealm = this.usernameTokenRealmCodec.getRealmFromToken(ut);
                if (secToken != null && (props = secToken.getProperties()) != null && !tokenRealm.equals(cachedRealm = (String)props.get("org.apache.cxf.sts.token.realm"))) {
                    return response;
                }
            }
            if (tokenParameters.getTokenStore() != null && secToken == null) {
                secToken = new SecurityToken(ut.getID());
                secToken.setToken(ut.getElement());
                int hashCode = ut.hashCode();
                String identifier = Integer.toString(hashCode);
                secToken.setTokenHash(hashCode);
                tokenParameters.getTokenStore().add(identifier, secToken);
            }
            response.setPrincipal(principal);
            response.setTokenRealm(tokenRealm);
            validateTarget.setState(ReceivedToken.STATE.VALID);
            LOG.fine("Username Token successfully validated");
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        catch (Base64DecodingException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        return response;
    }

    private Principal createPrincipal(String username, String passwordValue, String passwordType, String nonce, String createdTime) throws Base64DecodingException {
        boolean hashed = false;
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(passwordType)) {
            hashed = true;
        }
        WSUsernameTokenPrincipalImpl principal = new WSUsernameTokenPrincipalImpl(username, hashed);
        principal.setNonce(Base64.decode((String)nonce));
        principal.setPassword(passwordValue);
        principal.setCreatedTime(createdTime);
        principal.setPasswordType(passwordType);
        return principal;
    }

    public SubjectRoleParser getRoleParser() {
        return this.roleParser;
    }

    public void setRoleParser(SubjectRoleParser roleParser) {
        this.roleParser = roleParser;
    }
}

