/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.spi.api.Module;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;
import org.wildfly.swarm.spi.api.annotations.DeploymentModules;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;

@DeploymentScoped
public class DeploymentModulesArchivePreparer
implements DeploymentProcessor {
    private final Archive<?> archive;
    @Inject
    @Any
    private Instance<Fraction> allFractions;

    @Inject
    public DeploymentModulesArchivePreparer(Archive archive) {
        this.archive = archive;
    }

    public void process() {
        JARArchive jarArchive = (JARArchive)this.archive.as(JARArchive.class);
        for (Fraction each : this.allFractions) {
            DeploymentModules plural = each.getClass().getAnnotation(DeploymentModules.class);
            if (plural != null) {
                DeploymentModule[] entries;
                for (DeploymentModule entry : entries = plural.value()) {
                    this.addModule(jarArchive, entry);
                }
                continue;
            }
            DeploymentModule entry = each.getClass().getAnnotation(DeploymentModule.class);
            if (entry == null) continue;
            this.addModule(jarArchive, entry);
        }
    }

    protected void addModule(JARArchive archive, DeploymentModule entry) {
        SwarmMessages.MESSAGES.deploymentModuleAdded(entry);
        String moduleName = entry.name();
        String moduleSlot = entry.slot();
        if (moduleSlot.equals("")) {
            moduleSlot = "main";
        }
        Module def = archive.addModule(moduleName, moduleSlot);
        def.withExport(Boolean.valueOf(entry.export()));
        def.withMetaInf(entry.metaInf().toString().toLowerCase());
        def.withServices(entry.services());
    }
}

