/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Singleton;
import org.jboss.weld.literal.AnyLiteral;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.internal.OutboundSocketBindingRequest;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.api.cdi.CommonBean;
import org.wildfly.swarm.spi.api.cdi.CommonBeanBuilder;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

public class OutboundSocketBindingExtension
implements Extension {
    private final List<OutboundSocketBindingRequest> bindings;

    public OutboundSocketBindingExtension(List<OutboundSocketBindingRequest> bindings) {
        this.bindings = bindings;
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) throws Exception {
        try (AutoCloseable handle = Performance.time((String)"OutboundSocketBindingExtension.afterBeanDiscovery");){
            for (OutboundSocketBindingRequest each : this.bindings) {
                Supplier<Customizer> customizerSupplier = () -> () -> {
                    Set groups = beanManager.getBeans(SocketBindingGroup.class, new Annotation[]{AnyLiteral.INSTANCE});
                    groups.stream().map(e -> {
                        CreationalContext ctx = beanManager.createCreationalContext((Contextual)e);
                        return (SocketBindingGroup)beanManager.getReference(e, SocketBindingGroup.class, ctx);
                    }).filter(group -> group.name().equals(each.socketBindingGroup())).findFirst().ifPresent(group -> group.outboundSocketBinding(each.outboundSocketBinding()));
                };
                CommonBean customizerBean = CommonBeanBuilder.newBuilder(Customizer.class).beanClass(OutboundSocketBindingExtension.class).scope(Singleton.class).addQualifier((Annotation)Pre.Literal.INSTANCE).addQualifier((Annotation)AnyLiteral.INSTANCE).createSupplier(customizerSupplier).addType(Customizer.class).addType(Object.class).build();
                abd.addBean((Bean)customizerBean);
            }
        }
    }
}

