/* Generated By:JJTree: Do not edit this line. OIdentifier.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package com.orientechnologies.orient.core.sql.parser;

import java.util.Map;

public class OIdentifier extends SimpleNode {

  protected String  value;
  protected boolean quoted = false;

  public OIdentifier(int id) {
    super(id);
  }

  public OIdentifier(OrientSql p, int id) {
    super(p, id);
  }

  /** Accept the visitor. **/
  public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
    return visitor.visit(this, data);
  }

  /**
   * returns the value as is, with back-ticks quoted with backslash
   * @return
   */
  public String getValue() {
    return value;
  }

  /**
   * accepts a plain value. Back-ticks have to be quoted.
   * @param value
   */
  public void setValue(String value) {
    this.value = value;
  }

  /**
   * returns the plain string representation of this identifier, with quoting removed from back-ticks
   * @return
   */
  public String getStringValue(){
    if(value == null){
      return null;
    }
    return value.replaceAll("\\\\`", "`");
  }

  /**
   * returns the plain string representation of this identifier, with quoting removed from back-ticks
   * @return
   */
  public void setStringValue(String s){
    if(s == null){
      value = null;
    }else{
      value = s.replaceAll("`", "\\\\`");
    }
  }


  @Override
  public String toString(String prefix) {
    if (quoted) {
      return '`' + value + '`';
    }
    return value;
  }

  public String toString(){
    return toString("");
  }

  public void toString(Map<Object, Object> params, StringBuilder builder) {
    if (quoted) {
      builder.append('`' + value + '`');
    } else {
      builder.append(value);
    }
  }

}
/* JavaCC - OriginalChecksum=691a2eb5096f7b5e634b2ca8ac2ded3a (do not edit this line) */
