/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol;

import com.sun.corba.se.impl.encoding.CDRInputObject;
import com.sun.corba.se.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.se.impl.encoding.CodeSetConversion;
import com.sun.corba.se.impl.encoding.EncapsInputStream;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.CorbaInvocationInfo;
import com.sun.corba.se.pept.broker.Broker;
import com.sun.corba.se.pept.encoding.InputObject;
import com.sun.corba.se.pept.encoding.OutputObject;
import com.sun.corba.se.pept.protocol.ClientRequestDispatcher;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.OutboundConnectionCache;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.CodeSetsComponent;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersion;
import com.sun.corba.se.spi.orb.ORBVersionFactory;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.servicecontext.CodeSetServiceContext;
import com.sun.corba.se.spi.servicecontext.MaxStreamFormatVersionServiceContext;
import com.sun.corba.se.spi.servicecontext.ORBVersionServiceContext;
import com.sun.corba.se.spi.servicecontext.SendingContextServiceContext;
import com.sun.corba.se.spi.servicecontext.ServiceContext;
import com.sun.corba.se.spi.servicecontext.ServiceContexts;
import com.sun.corba.se.spi.servicecontext.UEInfoServiceContext;
import com.sun.corba.se.spi.servicecontext.UnknownServiceContext;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.CorbaContactInfo;
import com.sun.corba.se.spi.transport.CorbaContactInfoListIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import sun.corba.EncapsInputStreamFactory;

public class CorbaClientRequestDispatcherImpl
implements ClientRequestDispatcher {
    private ConcurrentMap<ContactInfo, Object> locks = new ConcurrentHashMap<ContactInfo, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public OutputObject beginRequest(Object self, String opName, boolean isOneWay, ContactInfo contactInfo) {
        Object connectionCache;
        Object lock;
        CorbaConnection connection;
        ORB orb;
        block31: {
            block32: {
                Object newLock;
                orb = null;
                CorbaContactInfo corbaContactInfo = (CorbaContactInfo)contactInfo;
                orb = (ORB)contactInfo.getBroker();
                if (orb.subcontractDebugFlag) {
                    this.dprint(".beginRequest->: op/" + opName);
                }
                orb.getPIHandler().initiateClientPIRequest(false);
                connection = null;
                lock = this.locks.get(contactInfo);
                if (lock == null && (lock = this.locks.putIfAbsent(contactInfo, newLock = new Object())) == null) {
                    lock = newLock;
                }
                newLock = lock;
                // MONITORENTER : newLock
                if (!contactInfo.isConnectionBased()) break block31;
                if (contactInfo.shouldCacheConnection()) {
                    connection = (CorbaConnection)orb.getTransportManager().getOutboundConnectionCache(contactInfo).get(contactInfo);
                }
                if (connection != null) {
                    if (orb.subcontractDebugFlag) {
                        this.dprint(".beginRequest: op/" + opName + ": Using cached connection: " + connection);
                    }
                    break block31;
                }
                try {
                    connection = (CorbaConnection)contactInfo.createConnection();
                    if (orb.subcontractDebugFlag) {
                        this.dprint(".beginRequest: op/" + opName + ": Using created connection: " + connection);
                    }
                }
                catch (RuntimeException e) {
                    boolean retry;
                    if (orb.subcontractDebugFlag) {
                        this.dprint(".beginRequest: op/" + opName + ": failed to create connection: " + e);
                    }
                    if (!(retry = this.getContactInfoListIterator(orb).reportException(contactInfo, e))) throw e;
                    if (!this.getContactInfoListIterator(orb).hasNext()) throw e;
                    contactInfo = (ContactInfo)this.getContactInfoListIterator(orb).next();
                    this.unregisterWaiter(orb);
                    OutputObject outputObject = this.beginRequest(self, opName, isOneWay, contactInfo);
                    // MONITOREXIT : newLock
                    if (!orb.subcontractDebugFlag) return outputObject;
                    this.dprint(".beginRequest<-: op/" + opName);
                    return outputObject;
                }
                if (!connection.shouldRegisterReadEvent()) break block32;
                orb.getTransportManager().getSelector(0).registerForEvent(connection.getEventHandler());
                connection.setState("ESTABLISHED");
            }
            if (contactInfo.shouldCacheConnection()) {
                OutboundConnectionCache connectionCache2 = orb.getTransportManager().getOutboundConnectionCache(contactInfo);
                connectionCache2.stampTime(connection);
                connectionCache2.put(contactInfo, connection);
            }
        }
        // MONITOREXIT : newLock
        CorbaMessageMediator messageMediator = (CorbaMessageMediator)contactInfo.createMessageMediator(orb, contactInfo, connection, opName, isOneWay);
        if (orb.subcontractDebugFlag) {
            this.dprint(".beginRequest: " + this.opAndId(messageMediator) + ": created message mediator: " + messageMediator);
        }
        orb.getInvocationInfo().setMessageMediator(messageMediator);
        if (connection != null && connection.getCodeSetContext() == null) {
            this.performCodeSetNegotiation(messageMediator);
        }
        this.addServiceContexts(messageMediator);
        OutputObject outputObject = contactInfo.createOutputObject(messageMediator);
        if (orb.subcontractDebugFlag) {
            this.dprint(".beginRequest: " + this.opAndId(messageMediator) + ": created output object: " + outputObject);
        }
        this.registerWaiter(messageMediator);
        Object retry = lock;
        // MONITORENTER : retry
        if (contactInfo.isConnectionBased() && contactInfo.shouldCacheConnection()) {
            connectionCache = orb.getTransportManager().getOutboundConnectionCache(contactInfo);
            connectionCache.reclaim();
        }
        // MONITOREXIT : retry
        orb.getPIHandler().setClientPIInfo(messageMediator);
        try {
            orb.getPIHandler().invokeClientPIStartingPoint();
        }
        catch (RemarshalException e) {
            if (orb.subcontractDebugFlag) {
                this.dprint(".beginRequest: " + this.opAndId(messageMediator) + ": Remarshal");
            }
            if (this.getContactInfoListIterator(orb).hasNext()) {
                contactInfo = (ContactInfo)this.getContactInfoListIterator(orb).next();
                if (orb.subcontractDebugFlag) {
                    this.dprint("RemarshalException: hasNext true\ncontact info " + contactInfo);
                }
                orb.getPIHandler().makeCompletedClientRequest(3, null);
                this.unregisterWaiter(orb);
                orb.getPIHandler().cleanupClientPIRequest();
                connectionCache = this.beginRequest(self, opName, isOneWay, contactInfo);
                if (!orb.subcontractDebugFlag) return connectionCache;
                this.dprint(".beginRequest<-: op/" + opName);
                return connectionCache;
            }
            if (orb.subcontractDebugFlag) {
                this.dprint("RemarshalException: hasNext false");
            }
            ORBUtilSystemException wrapper = ORBUtilSystemException.get(orb, "rpc.protocol");
            throw wrapper.remarshalWithNowhereToGo();
        }
        messageMediator.initializeMessage();
        if (!orb.subcontractDebugFlag) return outputObject;
        this.dprint(".beginRequest: " + this.opAndId(messageMediator) + ": initialized message");
        return outputObject;
        finally {
            if (orb.subcontractDebugFlag) {
                this.dprint(".beginRequest<-: op/" + opName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputObject marshalingComplete(Object self, OutputObject outputObject) throws ApplicationException, RemarshalException {
        ORB orb = null;
        CorbaMessageMediator messageMediator = null;
        try {
            messageMediator = (CorbaMessageMediator)outputObject.getMessageMediator();
            orb = (ORB)messageMediator.getBroker();
            if (orb.subcontractDebugFlag) {
                this.dprint(".marshalingComplete->: " + this.opAndId(messageMediator));
            }
            InputObject inputObject = this.marshalingComplete1(orb, messageMediator);
            InputObject inputObject2 = this.processResponse(orb, messageMediator, inputObject);
            return inputObject2;
        }
        finally {
            if (orb.subcontractDebugFlag) {
                this.dprint(".marshalingComplete<-: " + this.opAndId(messageMediator));
            }
        }
    }

    public InputObject marshalingComplete1(ORB orb, CorbaMessageMediator messageMediator) throws ApplicationException, RemarshalException {
        try {
            messageMediator.finishSendingRequest();
            if (orb.subcontractDebugFlag) {
                this.dprint(".marshalingComplete: " + this.opAndId(messageMediator) + ": finished sending request");
            }
            return messageMediator.waitForResponse();
        }
        catch (RuntimeException e) {
            if (orb.subcontractDebugFlag) {
                this.dprint(".marshalingComplete: " + this.opAndId(messageMediator) + ": exception: " + e.toString());
            }
            boolean retry = this.getContactInfoListIterator(orb).reportException(messageMediator.getContactInfo(), e);
            Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(2, e);
            if (retry) {
                if (newException == e) {
                    this.continueOrThrowSystemOrRemarshal(messageMediator, new RemarshalException());
                } else {
                    this.continueOrThrowSystemOrRemarshal(messageMediator, newException);
                }
            } else {
                if (newException instanceof RuntimeException) {
                    throw (RuntimeException)newException;
                }
                if (newException instanceof RemarshalException) {
                    throw (RemarshalException)newException;
                }
                throw e;
            }
            return null;
        }
    }

    protected InputObject processResponse(ORB orb, CorbaMessageMediator messageMediator, InputObject inputObject) throws ApplicationException, RemarshalException {
        ORBUtilSystemException wrapper = ORBUtilSystemException.get(orb, "rpc.protocol");
        if (orb.subcontractDebugFlag) {
            this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": response received");
        }
        if (messageMediator.getConnection() != null) {
            ((CorbaConnection)messageMediator.getConnection()).setPostInitialContexts();
        }
        Exception exception = null;
        if (messageMediator.isOneWay()) {
            this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
            exception = orb.getPIHandler().invokeClientPIEndingPoint(0, exception);
            this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
            return null;
        }
        this.consumeServiceContexts(orb, messageMediator);
        ((CDRInputObject)inputObject).performORBVersionSpecificInit();
        if (messageMediator.isSystemExceptionReply()) {
            UEInfoServiceContext usc;
            boolean doRemarshal;
            SystemException se = messageMediator.getSystemExceptionReply();
            if (orb.subcontractDebugFlag) {
                this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": received system exception: " + se);
            }
            if (doRemarshal = this.getContactInfoListIterator(orb).reportException(messageMediator.getContactInfo(), se)) {
                exception = orb.getPIHandler().invokeClientPIEndingPoint(2, se);
                if (se == exception) {
                    exception = null;
                    this.continueOrThrowSystemOrRemarshal(messageMediator, new RemarshalException());
                    throw wrapper.statementNotReachable1();
                }
                this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
                throw wrapper.statementNotReachable2();
            }
            ServiceContexts contexts = messageMediator.getReplyServiceContexts();
            if (contexts != null && (usc = (UEInfoServiceContext)contexts.get(9)) != null) {
                Throwable unknown = usc.getUE();
                UnknownException ue = new UnknownException(unknown);
                exception = orb.getPIHandler().invokeClientPIEndingPoint(2, ue);
                this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
                throw wrapper.statementNotReachable3();
            }
            exception = orb.getPIHandler().invokeClientPIEndingPoint(2, se);
            this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
            throw wrapper.statementNotReachable4();
        }
        if (messageMediator.isUserExceptionReply()) {
            if (orb.subcontractDebugFlag) {
                this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": received user exception");
            }
            this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
            String exceptionRepoId = this.peekUserExceptionId(inputObject);
            Exception newException = null;
            if (messageMediator.isDIIRequest()) {
                exception = messageMediator.unmarshalDIIUserException(exceptionRepoId, (InputStream)((Object)inputObject));
                newException = orb.getPIHandler().invokeClientPIEndingPoint(1, exception);
                messageMediator.setDIIException(newException);
            } else {
                ApplicationException appException = new ApplicationException(exceptionRepoId, (org.omg.CORBA.portable.InputStream)((Object)inputObject));
                exception = appException;
                newException = orb.getPIHandler().invokeClientPIEndingPoint(1, appException);
            }
            if (newException != exception) {
                this.continueOrThrowSystemOrRemarshal(messageMediator, newException);
            }
            if (newException instanceof ApplicationException) {
                throw (ApplicationException)newException;
            }
            return inputObject;
        }
        if (messageMediator.isLocationForwardReply()) {
            if (orb.subcontractDebugFlag) {
                this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": received location forward");
            }
            this.getContactInfoListIterator(orb).reportRedirect((CorbaContactInfo)messageMediator.getContactInfo(), messageMediator.getForwardedIOR());
            Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(3, null);
            if (!(newException instanceof RemarshalException)) {
                exception = newException;
            }
            if (exception != null) {
                this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
            }
            this.continueOrThrowSystemOrRemarshal(messageMediator, new RemarshalException());
            throw wrapper.statementNotReachable5();
        }
        if (messageMediator.isDifferentAddrDispositionRequestedReply()) {
            if (orb.subcontractDebugFlag) {
                this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": received different addressing dispostion request");
            }
            this.getContactInfoListIterator(orb).reportAddrDispositionRetry((CorbaContactInfo)messageMediator.getContactInfo(), messageMediator.getAddrDispositionReply());
            Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(5, null);
            if (!(newException instanceof RemarshalException)) {
                exception = newException;
            }
            if (exception != null) {
                this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
            }
            this.continueOrThrowSystemOrRemarshal(messageMediator, new RemarshalException());
            throw wrapper.statementNotReachable6();
        }
        if (orb.subcontractDebugFlag) {
            this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": received normal response");
        }
        this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
        messageMediator.handleDIIReply((InputStream)((Object)inputObject));
        exception = orb.getPIHandler().invokeClientPIEndingPoint(0, null);
        this.continueOrThrowSystemOrRemarshal(messageMediator, exception);
        return inputObject;
    }

    protected void continueOrThrowSystemOrRemarshal(CorbaMessageMediator messageMediator, Exception exception) throws SystemException, RemarshalException {
        ORB orb = (ORB)messageMediator.getBroker();
        if (exception != null) {
            if (exception instanceof RemarshalException) {
                orb.getInvocationInfo().setIsRetryInvocation(true);
                this.unregisterWaiter(orb);
                if (orb.subcontractDebugFlag) {
                    this.dprint(".continueOrThrowSystemOrRemarshal: " + this.opAndId(messageMediator) + ": throwing Remarshal");
                }
                throw (RemarshalException)exception;
            }
            if (orb.subcontractDebugFlag) {
                this.dprint(".continueOrThrowSystemOrRemarshal: " + this.opAndId(messageMediator) + ": throwing sex:" + exception);
            }
            throw (SystemException)exception;
        }
    }

    protected CorbaContactInfoListIterator getContactInfoListIterator(ORB orb) {
        return (CorbaContactInfoListIterator)((CorbaInvocationInfo)orb.getInvocationInfo()).getContactInfoListIterator();
    }

    protected void registerWaiter(CorbaMessageMediator messageMediator) {
        if (messageMediator.getConnection() != null) {
            messageMediator.getConnection().registerWaiter(messageMediator);
        }
    }

    protected void unregisterWaiter(ORB orb) {
        MessageMediator messageMediator = orb.getInvocationInfo().getMessageMediator();
        if (messageMediator != null && messageMediator.getConnection() != null) {
            messageMediator.getConnection().unregisterWaiter(messageMediator);
        }
    }

    protected void addServiceContexts(CorbaMessageMediator messageMediator) {
        ORB orb = (ORB)messageMediator.getBroker();
        CorbaConnection c = (CorbaConnection)messageMediator.getConnection();
        GIOPVersion giopVersion = messageMediator.getGIOPVersion();
        ServiceContexts contexts = messageMediator.getRequestServiceContexts();
        this.addCodeSetServiceContext(c, contexts, giopVersion);
        contexts.put(MaxStreamFormatVersionServiceContext.singleton);
        ORBVersionServiceContext ovsc = new ORBVersionServiceContext(ORBVersionFactory.getORBVersion());
        contexts.put(ovsc);
        if (c != null && !c.isPostInitialContexts()) {
            SendingContextServiceContext scsc = new SendingContextServiceContext(orb.getFVDCodeBaseIOR());
            contexts.put(scsc);
        }
    }

    protected void consumeServiceContexts(ORB orb, CorbaMessageMediator messageMediator) {
        ServiceContexts ctxts = messageMediator.getReplyServiceContexts();
        ORBUtilSystemException wrapper = ORBUtilSystemException.get(orb, "rpc.protocol");
        if (ctxts == null) {
            return;
        }
        ServiceContext sc = ctxts.get(6);
        if (sc != null) {
            SendingContextServiceContext scsc = (SendingContextServiceContext)sc;
            IOR ior = scsc.getIOR();
            try {
                if (messageMediator.getConnection() != null) {
                    ((CorbaConnection)messageMediator.getConnection()).setCodeBaseIOR(ior);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                throw wrapper.badStringifiedIor(t);
            }
        }
        if ((sc = ctxts.get(1313165056)) != null) {
            ORBVersionServiceContext ovsc = (ORBVersionServiceContext)sc;
            ORBVersion version = ovsc.getVersion();
            orb.setORBVersion(version);
        }
        this.getExceptionDetailMessage(messageMediator, wrapper);
    }

    protected void getExceptionDetailMessage(CorbaMessageMediator messageMediator, ORBUtilSystemException wrapper) {
        ServiceContext sc = messageMediator.getReplyServiceContexts().get(14);
        if (sc == null) {
            return;
        }
        if (!(sc instanceof UnknownServiceContext)) {
            throw wrapper.badExceptionDetailMessageServiceContextType();
        }
        byte[] data = ((UnknownServiceContext)sc).getData();
        EncapsInputStream in = EncapsInputStreamFactory.newEncapsInputStream((ORB)messageMediator.getBroker(), data, data.length);
        in.consumeEndian();
        String msg = "----------BEGIN server-side stack trace----------\n" + in.read_wstring() + "\n----------END server-side stack trace----------";
        messageMediator.setReplyExceptionDetailMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endRequest(Broker broker, Object self, InputObject inputObject) {
        ORB orb = (ORB)broker;
        try {
            MessageMediator messageMediator;
            if (orb.subcontractDebugFlag) {
                this.dprint(".endRequest->");
            }
            if ((messageMediator = orb.getInvocationInfo().getMessageMediator()) != null) {
                OutputObject outputObj;
                InputObject inputObj;
                if (messageMediator.getConnection() != null) {
                    ((CorbaMessageMediator)messageMediator).sendCancelRequestIfFinalFragmentNotSent();
                }
                if ((inputObj = messageMediator.getInputObject()) != null) {
                    inputObj.close();
                }
                if ((outputObj = messageMediator.getOutputObject()) != null) {
                    outputObj.close();
                }
            }
            this.unregisterWaiter(orb);
            orb.getPIHandler().cleanupClientPIRequest();
        }
        catch (IOException ex) {
            if (orb.subcontractDebugFlag) {
                this.dprint(".endRequest: ignoring IOException - " + ex.toString());
            }
        }
        finally {
            if (orb.subcontractDebugFlag) {
                this.dprint(".endRequest<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performCodeSetNegotiation(CorbaMessageMediator messageMediator) {
        CorbaConnection conn = (CorbaConnection)messageMediator.getConnection();
        IOR ior = ((CorbaContactInfo)messageMediator.getContactInfo()).getEffectiveTargetIOR();
        GIOPVersion giopVersion = messageMediator.getGIOPVersion();
        if (conn != null && conn.getCodeSetContext() == null && !giopVersion.equals(GIOPVersion.V1_0)) {
            CorbaConnection corbaConnection = conn;
            synchronized (corbaConnection) {
                if (conn.getCodeSetContext() != null) {
                    return;
                }
                IIOPProfileTemplate temp = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
                Iterator iter = temp.iteratorById(1);
                if (!iter.hasNext()) {
                    return;
                }
                CodeSetComponentInfo serverCodeSets = ((CodeSetsComponent)iter.next()).getCodeSetComponentInfo();
                CodeSetComponentInfo.CodeSetContext result = CodeSetConversion.impl().negotiate(conn.getBroker().getORBData().getCodeSetComponentInfo(), serverCodeSets);
                conn.setCodeSetContext(result);
            }
        }
    }

    protected void addCodeSetServiceContext(CorbaConnection conn, ServiceContexts ctxs, GIOPVersion giopVersion) {
        if (giopVersion.equals(GIOPVersion.V1_0) || conn == null) {
            return;
        }
        CodeSetComponentInfo.CodeSetContext codeSetCtx = null;
        if (conn.getBroker().getORBData().alwaysSendCodeSetServiceContext() || !conn.isPostInitialContexts()) {
            codeSetCtx = conn.getCodeSetContext();
        }
        if (codeSetCtx == null) {
            return;
        }
        CodeSetServiceContext cssc = new CodeSetServiceContext(codeSetCtx);
        ctxs.put(cssc);
    }

    protected String peekUserExceptionId(InputObject inputObject) {
        CDRInputObject cdrInputObject = (CDRInputObject)inputObject;
        cdrInputObject.mark(Integer.MAX_VALUE);
        String result = cdrInputObject.read_string();
        cdrInputObject.reset();
        return result;
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaClientRequestDispatcherImpl", msg);
    }

    protected String opAndId(CorbaMessageMediator mediator) {
        return ORBUtility.operationNameAndRequestId(mediator);
    }
}

