/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jaeger.deployment;

import com.uber.jaeger.Configuration;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.logging.Logger;

@WebListener
public class JaegerInitializer
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(JaegerInitializer.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext sc = servletContextEvent.getServletContext();
        String serviceName = JaegerInitializer.getProperty(sc, "JAEGER_SERVICE_NAME");
        if (serviceName == null || serviceName.isEmpty()) {
            logger.info((Object)"No Service Name set. Skipping initialization of the Jaeger Tracer.");
            return;
        }
        Configuration configuration = new Configuration(JaegerInitializer.getProperty(sc, "JAEGER_SERVICE_NAME"), new Configuration.SamplerConfiguration(JaegerInitializer.getProperty(sc, "JAEGER_SAMPLER_TYPE"), JaegerInitializer.getPropertyAsNumber(sc, "JAEGER_SAMPLER_PARAM"), JaegerInitializer.getProperty(sc, "JAEGER_SAMPLER_MANAGER_HOST_PORT")), new Configuration.ReporterConfiguration(JaegerInitializer.getPropertyAsBoolean(sc, "JAEGER_REPORTER_LOG_SPANS"), JaegerInitializer.getProperty(sc, "JAEGER_AGENT_HOST"), JaegerInitializer.getPropertyAsInt(sc, "JAEGER_AGENT_PORT"), JaegerInitializer.getPropertyAsInt(sc, "JAEGER_REPORTER_FLUSH_INTERVAL"), JaegerInitializer.getPropertyAsInt(sc, "JAEGER_REPORTER_MAX_QUEUE_SIZE")));
        GlobalTracer.register((Tracer)configuration.getTracer());
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    private static String getProperty(ServletContext sc, String name) {
        return sc.getInitParameter(name);
    }

    private static Integer getPropertyAsInt(ServletContext sc, String name) {
        String value = JaegerInitializer.getProperty(sc, name);
        if (value != null && !value.isEmpty()) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Failed to parse integer for property '" + name + "' with value '" + value + "'"), (Throwable)e);
            }
        }
        return null;
    }

    private static Boolean getPropertyAsBoolean(ServletContext sc, String name) {
        String value = JaegerInitializer.getProperty(sc, name);
        if (value != null && !value.isEmpty()) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    private static Number getPropertyAsNumber(ServletContext sc, String name) {
        String value = JaegerInitializer.getProperty(sc, name);
        if (value != null && !value.isEmpty()) {
            try {
                return NumberFormat.getInstance().parse(value);
            }
            catch (ParseException e) {
                logger.error((Object)("Failed to parse number for property '" + name + "' with value '" + value + "'"), (Throwable)e);
            }
        }
        return null;
    }
}

