/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.List;
import org.geolatte.geom.Complex;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.Simple;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class Geometries {
    public static <P extends Position> Point<P> mkPoint(P pos, CoordinateReferenceSystem<P> crs) {
        return new Point<P>(pos, crs);
    }

    public static <P extends Position> LineString<P> mkLineString(PositionSequence<P> seq, CoordinateReferenceSystem<P> crs) {
        return new LineString<P>(seq, crs);
    }

    public static <P extends Position> LinearRing<P> mkLinearRing(PositionSequence<P> seq, CoordinateReferenceSystem<P> crs) {
        return new LinearRing<P>(seq, crs);
    }

    public static <P extends Position> Polygon<P> mkPolygon(LinearRing<P> ... rings) {
        return new Polygon<P>(rings);
    }

    public static <P extends Position> Polygon<P> mkPolygon(List<LinearRing<P>> rings) {
        LinearRing[] ringArr = new LinearRing[rings.size()];
        return new Polygon(rings.toArray(ringArr));
    }

    public static <P extends Position> GeometryCollection<P, Geometry<P>> mkGeometryCollection(Geometry<P> ... geometries) {
        return new GeometryCollection((Geometry[])geometries);
    }

    public static <P extends Position> GeometryCollection<P, Geometry<P>> mkGeometryCollection(List<Geometry<P>> geometries) {
        Geometry[] geomArr = new Geometry[geometries.size()];
        return new GeometryCollection(geometries.toArray(geomArr));
    }

    public static <P extends Position> MultiPoint<P> mkMultiPoint(Point<P> ... points) {
        return new MultiPoint<P>(points);
    }

    public static <P extends Position> MultiPoint<P> mkMultiPoint(List<Point<P>> points) {
        Point[] pointArr = new Point[points.size()];
        return new MultiPoint(points.toArray(pointArr));
    }

    public static <P extends Position> MultiLineString<P> mkMultiLineString(List<LineString<P>> lineStrings) {
        LineString[] lsArr = new LineString[lineStrings.size()];
        return new MultiLineString(lineStrings.toArray(lsArr));
    }

    public static <P extends Position> MultiLineString<P> mkMultiLineString(LineString<P> ... linestrings) {
        return new MultiLineString<P>(linestrings);
    }

    public static <P extends Position> MultiPolygon<P> mkMultiPolygon(Polygon<P> ... polygons) {
        return new MultiPolygon<P>(polygons);
    }

    public static <P extends Position> MultiPolygon<P> mkMultiPolygon(List<Polygon<P>> polygons) {
        Polygon[] pArr = new Polygon[polygons.size()];
        return new MultiPolygon(polygons.toArray(pArr));
    }

    public static <P extends Position> Geometry<P> mkGeometry(Class<? extends Simple> geometryClass, PositionSequence<P> positions, CoordinateReferenceSystem<P> crs) {
        if (geometryClass == null) {
            throw new IllegalArgumentException("Null argument not allowed");
        }
        if (Point.class.isAssignableFrom(geometryClass)) {
            return new Point<PositionSequence<P>>(positions, crs);
        }
        if (LinearRing.class.isAssignableFrom(geometryClass)) {
            return new LinearRing<P>(positions, crs);
        }
        if (LineString.class.isAssignableFrom(geometryClass)) {
            return new LineString<P>(positions, crs);
        }
        throw new IllegalStateException("Unknown Geometry class");
    }

    public static <P extends Position> Geometry<P> mkGeometry(Class<? extends Complex> geometryClass, Geometry<P> ... parts) {
        if (Polygon.class.isAssignableFrom(geometryClass)) {
            return new Polygon((LinearRing[])parts);
        }
        if (MultiLineString.class.isAssignableFrom(geometryClass)) {
            return new MultiLineString((LineString[])parts);
        }
        if (MultiPoint.class.isAssignableFrom(geometryClass)) {
            return new MultiPoint((Point[])parts);
        }
        if (MultiPolygon.class.isAssignableFrom(geometryClass)) {
            return new MultiPolygon((Polygon[])parts);
        }
        if (GeometryCollection.class.isAssignableFrom(geometryClass)) {
            return new GeometryCollection((Geometry[])parts);
        }
        throw new IllegalStateException("Unknown Geometry class");
    }

    public static <Q extends Position> Geometry<Q> mkGeometry(Class<? extends Complex> geometryClass, CoordinateReferenceSystem<Q> crs) {
        if (Polygon.class.isAssignableFrom(geometryClass)) {
            return new Polygon<Q>(crs);
        }
        if (MultiLineString.class.isAssignableFrom(geometryClass)) {
            return new MultiLineString<Q>(crs);
        }
        if (MultiPoint.class.isAssignableFrom(geometryClass)) {
            return new MultiPoint<Q>(crs);
        }
        if (MultiPolygon.class.isAssignableFrom(geometryClass)) {
            return new MultiPolygon<Q>(crs);
        }
        if (GeometryCollection.class.isAssignableFrom(geometryClass)) {
            return new GeometryCollection(crs);
        }
        throw new IllegalStateException("Unknown Geometry class");
    }
}

