/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.opentracing.deployment;

import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.contrib.web.servlet.filter.TracingFilter;
import io.opentracing.util.GlobalTracer;
import java.util.EnumSet;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.logging.Logger;

@WebListener
public class OpenTracingInitializer
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(OpenTracingInitializer.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        String skipPatternAttribute = servletContext.getInitParameter(TracingFilter.SKIP_PATTERN);
        if (null != skipPatternAttribute && !skipPatternAttribute.isEmpty()) {
            servletContext.setAttribute(TracingFilter.SKIP_PATTERN, (Object)Pattern.compile(skipPatternAttribute));
        }
        logger.info((Object)"Registering Tracing Filter");
        FilterRegistration.Dynamic filterRegistration = servletContext.addFilter("tracingFilter", (Filter)new TracingFilter());
        filterRegistration.setAsyncSupported(true);
        filterRegistration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"*"});
        String skipParameter = servletContext.getInitParameter("skipOpenTracingResolver");
        if (skipParameter != null && Boolean.parseBoolean(skipParameter)) {
            logger.info((Object)"OpenTracing automatic resolution is being explicitly skipped.");
            return;
        }
        if (GlobalTracer.isRegistered()) {
            logger.info((Object)"A Tracer is already registered at the GlobalTracer. Skipping resolution via TraceResolver.");
            return;
        }
        Tracer tracer = TracerResolver.resolveTracer();
        if (null == tracer) {
            logger.info((Object)"Could not get a valid OpenTracing Tracer from the classpath. Skipping.");
            return;
        }
        logger.info((Object)String.format("Registering %s as the OpenTracing Tracer", tracer.getClass().getName()));
        GlobalTracer.register((Tracer)tracer);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

