/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.log;

import com.orientechnologies.common.parser.OVariableParser;
import com.orientechnologies.common.parser.OVariableParserListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;

public enum OAnsiCode {
    RESET("\u001b[0m"),
    BLACK("\u001b[30m"),
    RED("\u001b[31m"),
    GREEN("\u001b[32m"),
    YELLOW("\u001b[33m"),
    BLUE("\u001b[34m"),
    MAGENTA("\u001b[35m"),
    CYAN("\u001b[36m"),
    WHITE("\u001b[37m"),
    HIGH_INTENSITY("\u001b[1m"),
    LOW_INTENSITY("\u001b[2m"),
    ITALIC("\u001b[3m"),
    UNDERLINE("\u001b[4m"),
    BLINK("\u001b[5m"),
    RAPID_BLINK("\u001b[6m"),
    REVERSE_VIDEO("\u001b[7m"),
    INVISIBLE_TEXT("\u001b[8m"),
    BACKGROUND_BLACK("\u001b[40m"),
    BACKGROUND_RED("\u001b[41m"),
    BACKGROUND_GREEN("\u001b[42m"),
    BACKGROUND_YELLOW("\u001b[43m"),
    BACKGROUND_BLUE("\u001b[44m"),
    BACKGROUND_MAGENTA("\u001b[45m"),
    BACKGROUND_CYAN("\u001b[46m"),
    BACKGROUND_WHITE("\u001b[47m"),
    NULL("");

    private String code;
    private static final boolean supportsColors;

    private OAnsiCode(String code) {
        this.code = code;
    }

    public String toString() {
        return this.code;
    }

    public static boolean isSupportsColors() {
        return supportsColors;
    }

    public static String format(String message) {
        return OAnsiCode.format(message, supportsColors);
    }

    public static String format(String message, final boolean supportsColors) {
        return (String)OVariableParser.resolveVariables(message, "$ANSI{", "}", new OVariableParserListener(){

            @Override
            public Object resolve(String iVariable) {
                String text;
                int pos = iVariable.indexOf(32);
                String string = text = pos > -1 ? iVariable.substring(pos + 1) : "";
                if (supportsColors) {
                    String code = pos > -1 ? iVariable.substring(0, pos) : iVariable;
                    StringBuilder buffer = new StringBuilder();
                    String[] codes = code.split(":");
                    for (int i = 0; i < codes.length; ++i) {
                        buffer.append((Object)OAnsiCode.valueOf(codes[i].toUpperCase()));
                    }
                    if (pos > -1) {
                        buffer.append(text);
                        buffer.append((Object)RESET);
                    }
                    return buffer.toString();
                }
                return text;
            }
        });
    }

    static {
        String ansiSupport = OGlobalConfiguration.LOG_SUPPORTS_ANSI.getValueAsString();
        supportsColors = "true".equalsIgnoreCase(ansiSupport) ? true : ("auto".equalsIgnoreCase(ansiSupport) ? System.console() != null && !System.getProperty("os.name").contains("Windows") : false);
    }
}

