/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.collate;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.orient.core.collate.OCollate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OCaseInsensitiveCollate
extends ODefaultComparator
implements OCollate {
    public static final String NAME = "ci";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object transform(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).toLowerCase();
        }
        if (obj instanceof Set) {
            HashSet<Object> result = new HashSet<Object>();
            for (Object o : (Set)obj) {
                result.add(this.transform(o));
            }
            return result;
        }
        if (obj instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : (List)obj) {
                result.add(this.transform(o));
            }
            return result;
        }
        return obj;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OCaseInsensitiveCollate that = (OCaseInsensitiveCollate)obj;
        return this.getName().equals(that.getName());
    }

    public String toString() {
        return "{" + this.getClass().getSimpleName() + " : name = " + this.getName() + "}";
    }
}

