/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Map;

public class OCommandExecutorSQLExplain
extends OCommandExecutorSQLDelegate {
    public static final String KEYWORD_EXPLAIN = "EXPLAIN";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCommandExecutorSQLExplain parse(OCommandRequest iCommand) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iCommand;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iCommand);
            textRequest.setText(queryText);
            String cmd = ((OCommandRequestText)iCommand).getText();
            super.parse(new OCommandSQL(cmd.substring(KEYWORD_EXPLAIN.length())));
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        this.delegate.getContext().setRecordingMetrics(true);
        long startTime = System.nanoTime();
        Object result = super.execute(iArgs);
        ODocument report = new ODocument(this.delegate.getContext().getVariables());
        report.field("elapsed", Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f));
        if (result instanceof Collection) {
            report.field("resultType", "collection");
            report.field("resultSize", ((Collection)result).size());
        } else if (result instanceof ODocument) {
            report.field("resultType", "document");
            report.field("resultSize", 1);
        } else if (result instanceof Number) {
            report.field("resultType", "number");
        }
        return report;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.READ;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.REPLICATE;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT getDistributedResultManagement() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.MERGE;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }
}

