/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local;

import com.orientechnologies.common.collection.closabledictionary.OClosableEntry;
import com.orientechnologies.common.collection.closabledictionary.OClosableLinkedContainer;
import com.orientechnologies.common.concur.lock.ODistributedCounter;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OWriteCacheException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OBackgroundExceptionListener;
import com.orientechnologies.orient.core.storage.cache.local.PageGroup;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.zip.CRC32;

public class OWOWCache
extends OAbstractWriteCache
implements OWriteCache,
OCachePointer.WritersListener {
    private final int MAX_PAGES_PER_FLUSH;
    public static final String NAME_ID_MAP_EXTENSION = ".cm";
    private static final String NAME_ID_MAP = "name_id_map.cm";
    public static final int MIN_CACHE_SIZE = 16;
    public static final long MAGIC_NUMBER = 4207608830L;
    private static final double MAX_LSN_SEGMENT_DISTANCE_FACTOR = 0.75;
    private final long freeSpaceLimit = OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L;
    private final int diskSizeCheckInterval = OGlobalConfiguration.DISC_CACHE_FREE_SPACE_CHECK_INTERVAL_IN_PAGES.getValueAsInteger();
    private final List<WeakReference<OLowDiskSpaceListener>> listeners = new CopyOnWriteArrayList<WeakReference<OLowDiskSpaceListener>>();
    private final AtomicLong lastDiskSpaceCheck = new AtomicLong(0L);
    private final String storagePath;
    private final ConcurrentSkipListMap<PageKey, PageGroup> writeCachePages = new ConcurrentSkipListMap();
    private final ConcurrentSkipListSet<PageKey> exclusiveWritePages = new ConcurrentSkipListSet();
    private final ODistributedCounter writeCacheSize = new ODistributedCounter();
    private final ODistributedCounter exclusiveWriteCacheSize = new ODistributedCounter();
    private final ODistributedCounter cacheOverflowCount = new ODistributedCounter();
    private final OBinarySerializer<String> stringSerializer;
    private final OClosableLinkedContainer<Long, OFileClassic> files;
    private final boolean syncOnPageFlush;
    private final int pageSize;
    private final long groupTTL;
    private final OWriteAheadLog writeAheadLog;
    private final AtomicLong amountOfNewPagesAdded = new AtomicLong();
    private final OPartitionedLockManager<PageKey> lockManager = new OPartitionedLockManager();
    private final OLocalPaginatedStorage storageLocal;
    private final OReadersWriterSpinLock filesLock = new OReadersWriterSpinLock();
    private final ScheduledExecutorService commitExecutor;
    private final ExecutorService lowSpaceEventsPublisher;
    private volatile ConcurrentMap<String, Integer> nameIdMap;
    private RandomAccessFile nameIdMapHolder;
    private final int writeCacheMaxSize;
    private final int cacheMaxSize;
    private int fileCounter = 1;
    private PageKey lastPageKey = new PageKey(0, -1L);
    private PageKey lastWritePageKey = new PageKey(0, -1L);
    private File nameIdMapHolderFile;
    private final int id;
    private final OPerformanceStatisticManager performanceStatisticManager;
    private final OByteBufferPool bufferPool;
    private final List<WeakReference<OBackgroundExceptionListener>> backgroundExceptionListeners = new CopyOnWriteArrayList<WeakReference<OBackgroundExceptionListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWOWCache(boolean syncOnPageFlush, int pageSize, OByteBufferPool bufferPool, long groupTTL, OWriteAheadLog writeAheadLog, long pageFlushInterval, long writeCacheMaxSize, long cacheMaxSize, OLocalPaginatedStorage storageLocal, boolean checkMinSize, OClosableLinkedContainer<Long, OFileClassic> files, int id) {
        this.filesLock.acquireWriteLock();
        try {
            this.id = id;
            this.files = files;
            this.syncOnPageFlush = syncOnPageFlush;
            this.pageSize = pageSize;
            this.groupTTL = groupTTL;
            this.writeAheadLog = writeAheadLog;
            this.bufferPool = bufferPool;
            int writeNormalizedSize = this.normalizeMemory(writeCacheMaxSize, pageSize);
            if (checkMinSize && writeNormalizedSize < 16) {
                writeNormalizedSize = 16;
            }
            int normalizedSize = this.normalizeMemory(cacheMaxSize, pageSize);
            if (checkMinSize && normalizedSize < 16) {
                normalizedSize = 16;
            }
            this.writeCacheMaxSize = writeNormalizedSize;
            this.cacheMaxSize = normalizedSize;
            this.storageLocal = storageLocal;
            this.storagePath = storageLocal.getVariableParser().resolveVariables(storageLocal.getStoragePath());
            this.performanceStatisticManager = storageLocal.getPerformanceStatisticManager();
            OBinarySerializerFactory binarySerializerFactory = storageLocal.getComponentsFactory().binarySerializerFactory;
            this.stringSerializer = binarySerializerFactory.getObjectSerializer(OType.STRING);
            this.commitExecutor = Executors.newSingleThreadScheduledExecutor(new FlushThreadFactory(storageLocal.getName()));
            this.lowSpaceEventsPublisher = Executors.newCachedThreadPool(new LowSpaceEventsPublisherFactory(storageLocal.getName()));
            this.MAX_PAGES_PER_FLUSH = (int)(4000.0 / (1000.0 / (double)pageFlushInterval));
            if (pageFlushInterval > 0L) {
                this.commitExecutor.scheduleWithFixedDelay(new PeriodicFlushTask(), pageFlushInterval, pageFlushInterval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    public void loadRegisteredFiles() throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public void addBackgroundExceptionListener(OBackgroundExceptionListener listener) {
        this.backgroundExceptionListeners.add(new WeakReference<OBackgroundExceptionListener>(listener));
    }

    @Override
    public void removeBackgroundExceptionListener(OBackgroundExceptionListener listener) {
        ArrayList<WeakReference<OBackgroundExceptionListener>> itemsToRemove = new ArrayList<WeakReference<OBackgroundExceptionListener>>();
        for (WeakReference<OBackgroundExceptionListener> ref : this.backgroundExceptionListeners) {
            OBackgroundExceptionListener l = (OBackgroundExceptionListener)ref.get();
            if (l == null || !l.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        for (WeakReference<OBackgroundExceptionListener> ref : itemsToRemove) {
            this.backgroundExceptionListeners.remove(ref);
        }
    }

    private void fireBackgroundDataProcessingExceptionEvent(Throwable e) {
        for (WeakReference<OBackgroundExceptionListener> ref : this.backgroundExceptionListeners) {
            OBackgroundExceptionListener listener = (OBackgroundExceptionListener)ref.get();
            if (listener == null) continue;
            listener.onException(e);
        }
    }

    private int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)pageSize;
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    @Override
    public File getRootDirectory() {
        return new File(this.storagePath);
    }

    @Override
    public OPerformanceStatisticManager getPerformanceStatisticManager() {
        return this.performanceStatisticManager;
    }

    @Override
    public void startFuzzyCheckpoints() {
        if (this.writeAheadLog != null) {
            long fuzzyCheckPointInterval = OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL.getValueAsInteger();
            this.commitExecutor.scheduleWithFixedDelay(new PeriodicalFuzzyCheckpointTask(), fuzzyCheckPointInterval, fuzzyCheckPointInterval, TimeUnit.SECONDS);
        }
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.listeners.add(new WeakReference<OLowDiskSpaceListener>(listener));
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<WeakReference<OLowDiskSpaceListener>> itemsToRemove = new ArrayList<WeakReference<OLowDiskSpaceListener>>();
        for (WeakReference<OLowDiskSpaceListener> ref : this.listeners) {
            OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)ref.get();
            if (lowDiskSpaceListener != null && !lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        for (WeakReference<OLowDiskSpaceListener> ref : itemsToRemove) {
            this.listeners.remove(ref);
        }
    }

    private void freeSpaceCheckAfterNewPageAdd() {
        long lastSpaceCheck;
        long newPagesAdded = this.amountOfNewPagesAdded.incrementAndGet();
        if (newPagesAdded - (lastSpaceCheck = this.lastDiskSpaceCheck.get()) > (long)this.diskSizeCheckInterval || lastSpaceCheck == 0L) {
            File storageDir = new File(this.storagePath);
            long freeSpace = storageDir.getFreeSpace();
            if (freeSpace < this.freeSpaceLimit) {
                this.callLowSpaceListeners(new OLowDiskSpaceInformation(freeSpace, this.freeSpaceLimit));
            }
            this.lastDiskSpaceCheck.lazySet(newPagesAdded);
        }
    }

    private void callLowSpaceListeners(final OLowDiskSpaceInformation information) {
        this.lowSpaceEventsPublisher.execute(new Runnable(){

            @Override
            public void run() {
                for (WeakReference lowDiskSpaceListenerWeakReference : OWOWCache.this.listeners) {
                    OLowDiskSpaceListener listener = (OLowDiskSpaceListener)lowDiskSpaceListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.lowDiskSpace(information);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error during notification of low disk space for storage " + OWOWCache.this.storageLocal.getName(), e, new Object[0]);
                    }
                }
            }
        });
    }

    private static int calculatePageCrc(byte[] pageData) {
        int systemSize = 12;
        CRC32 crc32 = new CRC32();
        crc32.update(pageData, 12, pageData.length - 12);
        return (int)crc32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bookFileId(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId < 0) {
                long l = OWOWCache.composeFileId(this.id, -fileId.intValue());
                return l;
            }
            ++this.fileCounter;
            long l = OWOWCache.composeFileId(this.id, this.fileCounter);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public boolean fileIdsAreEqual(long firsId, long secondId) {
        int secondIntId;
        int firstIntId = OWOWCache.extractFileId(firsId);
        return firstIntId == (secondIntId = OWOWCache.extractFileId(secondId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long loadFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                long externalId = OWOWCache.composeFileId(this.id, fileId);
                OFileClassic fileClassic = this.files.get(externalId);
                if (fileClassic != null) {
                    long l = externalId;
                    return l;
                }
                throw new OStorageException("File with given name " + fileName + " only partially registered in storage");
            }
            OFileClassic fileClassic = this.createFileInstance(fileName);
            if (!fileClassic.exists()) {
                throw new OStorageException("File with name " + fileName + " does not exist in storage " + this.storageLocal.getName());
            }
            OLogManager.instance().debug((Object)this, "File '" + fileName + "' is not registered in 'file name - id' map, but exists in file system. Registering it", new Object[0]);
            if (fileId == null) {
                ++this.fileCounter;
                fileId = this.fileCounter;
            } else {
                fileId = -fileId.intValue();
            }
            this.openFile(fileClassic);
            long externalId = OWOWCache.composeFileId(this.id, fileId);
            this.files.add(externalId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            long l = externalId;
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                throw new OStorageException("File with name " + fileName + " already exists in storage " + this.storageLocal.getName());
            }
            if (fileId == null) {
                ++this.fileCounter;
                fileId = this.fileCounter;
            } else {
                fileId = -fileId.intValue();
            }
            OFileClassic fileClassic = this.createFileInstance(fileName);
            this.createFile(fileClassic);
            long externalId = OWOWCache.composeFileId(this.id, fileId);
            this.files.add(externalId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            long l = externalId;
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public long fileIdByName(String fileName) {
        Integer intId = (Integer)this.nameIdMap.get(fileName);
        if (intId == null || intId < 0) {
            return -1L;
        }
        return OWOWCache.composeFileId(this.id, intId);
    }

    @Override
    public int internalFileId(long fileId) {
        return OWOWCache.extractFileId(fileId);
    }

    @Override
    public long externalFileId(int fileId) {
        return OWOWCache.composeFileId(this.id, fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer existingFileId = (Integer)this.nameIdMap.get(fileName);
            int intId = OWOWCache.extractFileId(fileId);
            if (existingFileId != null && existingFileId >= 0) {
                if (existingFileId == intId) {
                    throw new OStorageException("File with name '" + fileName + "'' already exists in storage '" + this.storageLocal.getName() + "'");
                }
                throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            fileId = OWOWCache.composeFileId(this.id, intId);
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null) {
                if (!fileClassic.getName().equals(fileName)) {
                    throw new OStorageException("File with given id exists but has different name " + fileClassic.getName() + " vs. proposed " + fileName);
                }
            } else {
                if (this.fileCounter < intId) {
                    this.fileCounter = intId;
                }
                fileClassic = this.createFileInstance(fileName);
                this.createFile(fileClassic);
                this.files.add(fileId, fileClassic);
            }
            this.nameIdMap.put(fileName, intId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, intId), true);
            long l = fileId;
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public boolean checkLowDiskSpace() {
        File storageDir = new File(this.storagePath);
        long freeSpace = storageDir.getFreeSpace();
        return freeSpace < this.freeSpaceLimit;
    }

    @Override
    public void makeFuzzyCheckpoint() {
        if (this.writeAheadLog != null) {
            this.writeAheadLog.flush();
            Future<?> future = this.commitExecutor.submit(new PeriodicalFuzzyCheckpointTask());
            try {
                future.get();
            }
            catch (Exception e) {
                throw OException.wrapException(new OStorageException("Error during fuzzy checkpoint execution for storage " + this.storageLocal.getName()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String fileName) {
        this.filesLock.acquireReadLock();
        try {
            Integer fileId;
            if (this.nameIdMap != null && (fileId = (Integer)this.nameIdMap.get(fileName)) != null && fileId >= 0) {
                boolean bl = true;
                return bl;
            }
            File file = new File(this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName));
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(long fileId) {
        this.filesLock.acquireReadLock();
        try {
            int intId = OWOWCache.extractFileId(fileId);
            fileId = OWOWCache.composeFileId(this.id, intId);
            OFileClassic file = this.files.get(fileId);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future store(long fileId, long pageIndex, OCachePointer dataPointer) {
        Future<?> future = null;
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            PageKey pageKey = new PageKey(intId, pageIndex);
            Lock groupLock = this.lockManager.acquireExclusiveLock(pageKey);
            try {
                PageGroup pageGroup = this.writeCachePages.get(pageKey);
                if (pageGroup == null) {
                    pageGroup = new PageGroup(System.currentTimeMillis(), dataPointer);
                    this.writeCachePages.put(pageKey, pageGroup);
                    this.writeCacheSize.increment();
                    dataPointer.setWritersListener(this);
                    dataPointer.incrementWritersReferrer();
                }
                assert (pageGroup.page.equals(dataPointer));
                pageGroup.recencyBit = true;
            }
            finally {
                this.lockManager.releaseLock(groupLock);
            }
            if (this.exclusiveWriteCacheSize.get() > (long)this.writeCacheMaxSize) {
                this.cacheOverflowCount.increment();
                future = this.commitExecutor.submit(new PeriodicFlushTask());
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> files() {
        this.filesLock.acquireReadLock();
        try {
            HashMap result = new HashMap();
            for (Map.Entry entry : this.nameIdMap.entrySet()) {
                if ((Integer)entry.getValue() <= 0) continue;
                result.put(entry.getKey(), OWOWCache.composeFileId(this.id, (Integer)entry.getValue()));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCachePointer[] load(long fileId, long startPageIndex, int pageCount, boolean addNewPages, OModifiableBoolean cacheHit) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        if (pageCount < 1) {
            throw new IllegalArgumentException("Amount of pages to load should be not less than 1 but provided value is " + pageCount);
        }
        this.filesLock.acquireReadLock();
        try {
            OCachePointer[] oCachePointerArray;
            PageGroup pageGroup;
            Lock[] pageLocks;
            block18: {
                OCachePointer[] pagePointers;
                PageKey[] pageKeys;
                block19: {
                    pageKeys = new PageKey[pageCount];
                    for (int i = 0; i < pageCount; ++i) {
                        pageKeys[i] = new PageKey(intId, startPageIndex + (long)i);
                    }
                    pageLocks = this.lockManager.acquireSharedLocksInBatch((PageKey[])pageKeys);
                    pageGroup = this.writeCachePages.get(pageKeys[0]);
                    if (pageGroup != null) break block18;
                    pagePointers = this.cacheFileContent(intId, startPageIndex, pageCount, addNewPages, cacheHit);
                    if (pagePointers.length != 0) break block19;
                    OCachePointer[] oCachePointerArray2 = pagePointers;
                    for (Lock lock : pageLocks) {
                        lock.unlock();
                    }
                    return oCachePointerArray2;
                }
                for (int n = 0; n < pagePointers.length; ++n) {
                    pagePointers[n].incrementReadersReferrer();
                    if (n <= 0) continue;
                    pageGroup = this.writeCachePages.get(pageKeys[n]);
                    assert (pageKeys[n].pageIndex == pagePointers[n].getPageIndex());
                    if (pageGroup == null) continue;
                    pagePointers[n].decrementReadersReferrer();
                    pagePointers[n] = pageGroup.page;
                    pagePointers[n].incrementReadersReferrer();
                }
                OCachePointer[] oCachePointerArray3 = pagePointers;
                for (Lock lock : pageLocks) {
                    lock.unlock();
                }
                return oCachePointerArray3;
            }
            try {
                OCachePointer pagePointer = pageGroup.page;
                pagePointer.incrementReadersReferrer();
                cacheHit.setValue(true);
                oCachePointerArray = new OCachePointer[]{pagePointer};
            }
            catch (Throwable throwable) {
                for (Lock lock : pageLocks) {
                    lock.unlock();
                }
                throw throwable;
            }
            for (Lock lock : pageLocks) {
                lock.unlock();
            }
            return oCachePointerArray;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public void addOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.increment();
        this.exclusiveWritePages.add(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void removeOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.decrement();
        this.exclusiveWritePages.remove(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void flush(long fileId) {
        Future<Void> future = this.commitExecutor.submit(new FileFlushTask(OWOWCache.extractFileId(fileId)));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OInterruptedException("File flush was interrupted");
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File flush was abnormally terminated"), e);
        }
    }

    @Override
    public void flush() {
        int counter = 0;
        Iterator iterator = this.nameIdMap.values().iterator();
        while (iterator.hasNext()) {
            int intId = (Integer)iterator.next();
            if (intId < 0) continue;
            long externalId = OWOWCache.composeFileId(this.id, intId);
            this.flush(externalId);
            ++counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilledUpTo(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireReadLock();
        try {
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                long l = entry.get().getFileSize() / (long)this.pageSize;
                this.files.release(entry);
                return l;
            }
            catch (Throwable throwable) {
                this.files.release(entry);
                throw throwable;
            }
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public long getExclusiveWriteCachePagesSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            String name = this.doDeleteFile(intId);
            if (name != null) {
                this.nameIdMap.put(name, -intId);
                this.writeNameIdEntry(new NameFileIdEntry(name, -intId), true);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            this.removeCachedPages(intId);
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                entry.get().shrink(0L);
            }
            finally {
                this.files.release(entry);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String oldFileName, String newFileName) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            if (entry == null) {
                return;
            }
            try {
                OFileClassic file = entry.get();
                String osFileName = file.getName();
                if (osFileName.startsWith(oldFileName)) {
                    File newFile = new File(this.storageLocal.getStoragePath() + File.separator + newFileName + osFileName.substring(osFileName.lastIndexOf(oldFileName) + oldFileName.length()));
                    boolean renamed = file.renameTo(newFile);
                    while (!renamed) {
                        renamed = file.renameTo(newFile);
                    }
                }
            }
            finally {
                this.files.release(entry);
            }
            this.nameIdMap.remove(oldFileName);
            this.nameIdMap.put(newFileName, intId);
            this.writeNameIdEntry(new NameFileIdEntry(oldFileName, -1), false);
            this.writeNameIdEntry(new NameFileIdEntry(newFileName, intId), true);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public long[] close() throws IOException {
        this.flush();
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OWriteCacheException("Background data flush task cannot be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.interrupted();
                throw OException.wrapException(new OWriteCacheException("Data flush thread was interrupted"), e);
            }
        }
        ArrayList<Long> result = new ArrayList<Long>();
        this.filesLock.acquireWriteLock();
        try {
            Collection intIds = this.nameIdMap.values();
            for (Integer n : intIds) {
                if (n < 0) continue;
                long fileId = OWOWCache.composeFileId(this.id, n);
                OFileClassic fileClassic = this.files.remove(fileId);
                fileClassic.close();
                result.add(fileId);
            }
            if (this.nameIdMapHolder != null) {
                this.nameIdMapHolder.setLength(0L);
                for (Map.Entry entry : this.nameIdMap.entrySet()) {
                    this.writeNameIdEntry(new NameFileIdEntry((String)entry.getKey(), (Integer)entry.getValue()), false);
                }
                this.nameIdMapHolder.getFD().sync();
                this.nameIdMapHolder.close();
            }
            this.nameIdMap.clear();
            long[] ds = new long[result.size()];
            boolean bl = false;
            Object object = result.iterator();
            while (object.hasNext()) {
                void var4_9;
                long id;
                ds[var4_9] = id = ((Long)object.next()).longValue();
                ++var4_9;
            }
            object = ds;
            return object;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long fileId, boolean flush) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            if (flush) {
                this.flush(intId);
            } else {
                this.removeCachedPages(intId);
            }
            if (!this.files.close(fileId)) {
                throw new OStorageException("Can not close file with id " + this.internalFileId(fileId) + " because it is still in use");
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        int notificationTimeOut = 5000;
        ArrayList<OPageDataVerificationError> errors = new ArrayList<OPageDataVerificationError>();
        this.filesLock.acquireWriteLock();
        try {
            for (Integer intId : this.nameIdMap.values()) {
                boolean fileIsCorrect;
                if (intId < 0) continue;
                long externalId = OWOWCache.composeFileId(this.id, intId);
                OClosableEntry<Long, OFileClassic> entry = this.files.acquire(externalId);
                OFileClassic fileClassic = entry.get();
                try {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Flashing file " + fileClassic.getName() + "... ");
                    }
                    this.flush(intId.intValue());
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Start verification of content of " + fileClassic.getName() + "file ...");
                    }
                    long time = System.currentTimeMillis();
                    long filledUpTo = fileClassic.getFileSize();
                    fileIsCorrect = true;
                    for (long pos = 0L; pos < filledUpTo; pos += (long)this.pageSize) {
                        int calculatedCRC32;
                        int storedCRC32;
                        boolean checkSumIncorrect = false;
                        boolean magicNumberIncorrect = false;
                        byte[] data = new byte[this.pageSize];
                        fileClassic.read(pos, data, data.length);
                        long magicNumber = OLongSerializer.INSTANCE.deserializeNative(data, 0);
                        if (magicNumber != 4207608830L) {
                            magicNumberIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Magic number for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " does not much !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if ((storedCRC32 = OIntegerSerializer.INSTANCE.deserializeNative(data, 8)) != (calculatedCRC32 = OWOWCache.calculatePageCrc(data))) {
                            checkSumIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Checksum for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " is incorrect !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if (magicNumberIncorrect || checkSumIncorrect) {
                            errors.add(new OPageDataVerificationError(magicNumberIncorrect, checkSumIncorrect, pos / (long)this.pageSize, fileClassic.getName()));
                        }
                        if (commandOutputListener == null || System.currentTimeMillis() - time <= 5000L) continue;
                        time = 5000L;
                        commandOutputListener.onMessage(pos / (long)this.pageSize + " pages were processed ...");
                    }
                }
                catch (IOException ioe) {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Error: Error during processing of file " + fileClassic.getName() + ". " + ioe.getMessage());
                    }
                    fileIsCorrect = false;
                }
                finally {
                    this.files.release(entry);
                }
                if (!fileIsCorrect) {
                    if (commandOutputListener == null) continue;
                    commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is finished with errors.");
                    continue;
                }
                if (commandOutputListener == null) continue;
                commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is successfully finished.");
            }
            OPageDataVerificationError[] oPageDataVerificationErrorArray = errors.toArray(new OPageDataVerificationError[errors.size()]);
            return oPageDataVerificationErrorArray;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] delete() throws IOException {
        ArrayList<Long> result = new ArrayList<Long>();
        this.filesLock.acquireWriteLock();
        try {
            Iterator iterator = this.nameIdMap.values().iterator();
            while (iterator.hasNext()) {
                int intId = (Integer)iterator.next();
                if (intId < 0) continue;
                long externalId = OWOWCache.composeFileId(this.id, intId);
                this.doDeleteFile(externalId);
                result.add(externalId);
            }
            if (this.nameIdMapHolderFile != null) {
                if (this.nameIdMapHolderFile.exists()) {
                    this.nameIdMapHolder.close();
                    if (!this.nameIdMapHolderFile.delete()) {
                        throw new OStorageException("Cannot delete disk cache file which contains name-id mapping.");
                    }
                }
                this.nameIdMapHolder = null;
                this.nameIdMapHolderFile = null;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OWriteCacheException("Background data flush task cannot be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.interrupted();
                throw new OInterruptedException("Data flush thread was interrupted");
            }
        }
        long[] ids = new long[result.size()];
        int counter = 0;
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            long id;
            ids[counter] = id = ((Long)iterator.next()).longValue();
            ++counter;
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileNameById(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireReadLock();
        try {
            OFileClassic f = this.files.get(fileId);
            String string = f != null ? f.getName() : null;
            return string;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    public long getCacheOverflowCount() {
        return this.cacheOverflowCount.get();
    }

    public long getWriteCacheSize() {
        return this.writeCacheSize.get();
    }

    public long getExclusiveWriteCacheSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    private void openFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
        } else {
            throw new OStorageException("File " + fileClassic + " does not exist.");
        }
    }

    private void createFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            throw new OStorageException("File '" + fileClassic.getName() + "' already exists.");
        }
        fileClassic.create();
        fileClassic.synch();
    }

    private void initNameIdMapping() throws IOException {
        if (this.nameIdMapHolder == null) {
            File storagePath = new File(this.storageLocal.getStoragePath());
            if (!storagePath.exists() && !storagePath.mkdirs()) {
                throw new OStorageException("Cannot create directories for the path '" + storagePath + "'");
            }
            this.nameIdMapHolderFile = new File(storagePath, NAME_ID_MAP);
            this.nameIdMapHolder = new RandomAccessFile(this.nameIdMapHolderFile, "rw");
            this.readNameIdMap();
        }
    }

    private OFileClassic createFileInstance(String fileName) {
        String path = this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName);
        return new OFileClassic(path, this.storageLocal.getMode());
    }

    private void readNameIdMap() throws IOException {
        NameFileIdEntry nameFileIdEntry;
        this.nameIdMap = new ConcurrentHashMap<String, Integer>();
        long localFileCounter = -1L;
        this.nameIdMapHolder.seek(0L);
        while ((nameFileIdEntry = this.readNextNameIdEntry()) != null) {
            long absFileId = Math.abs(nameFileIdEntry.fileId);
            if (localFileCounter < absFileId) {
                localFileCounter = absFileId;
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
        }
        if (localFileCounter > 0L) {
            this.fileCounter = (int)localFileCounter;
        }
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            long externalId;
            if ((Integer)nameIdEntry.getValue() < 0 || this.files.get(externalId = OWOWCache.composeFileId(this.id, (Integer)nameIdEntry.getValue())) != null) continue;
            OFileClassic fileClassic = this.createFileInstance((String)nameIdEntry.getKey());
            if (fileClassic.exists()) {
                fileClassic.open();
                this.files.add(externalId, fileClassic);
                continue;
            }
            Integer fileId = (Integer)this.nameIdMap.get(nameIdEntry.getKey());
            if (fileId == null || fileId <= 0) continue;
            this.nameIdMap.put((String)nameIdEntry.getKey(), -fileId.intValue());
        }
    }

    private NameFileIdEntry readNextNameIdEntry() throws IOException {
        try {
            int nameSize = this.nameIdMapHolder.readInt();
            byte[] serializedName = new byte[nameSize];
            this.nameIdMapHolder.readFully(serializedName);
            String name = this.stringSerializer.deserialize(serializedName, 0);
            int fileId = (int)this.nameIdMapHolder.readLong();
            return new NameFileIdEntry(name, fileId);
        }
        catch (EOFException eof) {
            return null;
        }
    }

    private void writeNameIdEntry(NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        this.nameIdMapHolder.seek(this.nameIdMapHolder.length());
        int nameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.name, new Object[0]);
        byte[] serializedRecord = new byte[4 + nameSize + 8];
        OIntegerSerializer.INSTANCE.serializeLiteral(nameSize, serializedRecord, 0);
        this.stringSerializer.serialize(nameFileIdEntry.name, serializedRecord, 4, new Object[0]);
        OLongSerializer.INSTANCE.serializeLiteral(nameFileIdEntry.fileId, serializedRecord, 4 + nameSize);
        this.nameIdMapHolder.write(serializedRecord);
        if (sync) {
            this.nameIdMapHolder.getFD().sync();
        }
    }

    private String doDeleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.removeCachedPages(intId);
        OFileClassic fileClassic = this.files.remove(fileId);
        String name = null;
        if (fileClassic != null) {
            name = fileClassic.getName();
            if (fileClassic.exists()) {
                fileClassic.delete();
            }
        }
        return name;
    }

    private void removeCachedPages(int fileId) {
        if (this.commitExecutor.isShutdown()) {
            return;
        }
        Future<Void> future = this.commitExecutor.submit(new RemoveFilePagesTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OInterruptedException("File data removal was interrupted");
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File data removal was abnormally terminated"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OCachePointer[] cacheFileContent(int intId, long startPageIndex, int pageCount, boolean addNewPages, OModifiableBoolean cacheHit) throws IOException {
        long fileId = OWOWCache.composeFileId(this.id, intId);
        OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
        try {
            OFileClassic fileClassic = entry.get();
            if (fileClassic == null) {
                throw new IllegalArgumentException("File with id " + intId + " not found in WOW Cache");
            }
            OLogSequenceNumber lastLsn = this.writeAheadLog != null ? this.writeAheadLog.getFlushedLsn() : new OLogSequenceNumber(-1L, -1L);
            long firstPageStartPosition = startPageIndex * (long)this.pageSize;
            long firstPageEndPosition = firstPageStartPosition + (long)this.pageSize;
            if (fileClassic.getFileSize() >= firstPageEndPosition) {
                OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
                if (sessionStoragePerformanceStatistic != null) {
                    sessionStoragePerformanceStatistic.startPageReadFromFileTimer();
                }
                int pagesRead = 0;
                try {
                    int n;
                    if (pageCount == 1) {
                        ByteBuffer buffer = this.bufferPool.acquireDirect(false);
                        fileClassic.read(firstPageStartPosition, buffer);
                        buffer.position(0);
                        OCachePointer dataPointer = new OCachePointer(buffer, this.bufferPool, lastLsn, fileId, startPageIndex);
                        pagesRead = 1;
                        OCachePointer[] oCachePointerArray = new OCachePointer[]{dataPointer};
                        return oCachePointerArray;
                    }
                    long maxPageCount = (fileClassic.getFileSize() - firstPageStartPosition) / (long)this.pageSize;
                    int realPageCount = Math.min((int)maxPageCount, pageCount);
                    ByteBuffer[] buffers = new ByteBuffer[realPageCount];
                    for (int i = 0; i < buffers.length; ++i) {
                        buffers[i] = this.bufferPool.acquireDirect(false);
                        assert (buffers[i].position() == 0);
                    }
                    long bytesRead = fileClassic.read(firstPageStartPosition, buffers);
                    assert (bytesRead % (long)this.pageSize == 0L);
                    int buffersRead = (int)(bytesRead / (long)this.pageSize);
                    OCachePointer[] dataPointers = new OCachePointer[buffersRead];
                    for (n = 0; n < buffersRead; ++n) {
                        buffers[n].position(0);
                        dataPointers[n] = new OCachePointer(buffers[n], this.bufferPool, lastLsn, fileId, startPageIndex + (long)n);
                    }
                    for (n = buffersRead; n < buffers.length; ++n) {
                        this.bufferPool.release(buffers[n]);
                    }
                    pagesRead = dataPointers.length;
                    OCachePointer[] oCachePointerArray = dataPointers;
                    return oCachePointerArray;
                }
                finally {
                    if (sessionStoragePerformanceStatistic != null) {
                        sessionStoragePerformanceStatistic.stopPageReadFromFileTimer(pagesRead);
                    }
                }
            }
            if (addNewPages) {
                int space = (int)(firstPageEndPosition - fileClassic.getFileSize());
                if (space > 0) {
                    fileClassic.allocateSpace(space);
                }
                this.freeSpaceCheckAfterNewPageAdd();
                ByteBuffer buffer = this.bufferPool.acquireDirect(true);
                OCachePointer dataPointer = new OCachePointer(buffer, this.bufferPool, lastLsn, fileId, startPageIndex);
                cacheHit.setValue(true);
                OCachePointer[] oCachePointerArray = new OCachePointer[]{dataPointer};
                return oCachePointerArray;
            }
            OCachePointer[] oCachePointerArray = new OCachePointer[]{};
            return oCachePointerArray;
        }
        finally {
            this.files.release(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPage(int fileId, long pageIndex, ByteBuffer buffer) throws IOException {
        if (this.writeAheadLog != null) {
            OLogSequenceNumber lsn = ODurablePage.getLogSequenceNumberFromPage(buffer);
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLsn();
            if (flushedLSN == null || flushedLSN.compareTo(lsn) < 0) {
                this.writeAheadLog.flush();
            }
        }
        byte[] content = new byte[this.pageSize];
        buffer.position(0);
        buffer.get(content);
        OLongSerializer.INSTANCE.serializeNative(4207608830L, content, 0, new Object[0]);
        int crc32 = OWOWCache.calculatePageCrc(content);
        OIntegerSerializer.INSTANCE.serializeNative(crc32, content, 8, new Object[0]);
        long externalId = OWOWCache.composeFileId(this.id, fileId);
        OClosableEntry<Long, OFileClassic> entry = this.files.acquire(externalId);
        try {
            OFileClassic fileClassic = entry.get();
            fileClassic.write(pageIndex * (long)this.pageSize, content);
            if (this.syncOnPageFlush) {
                fileClassic.synch();
            }
        }
        finally {
            this.files.release(entry);
        }
    }

    private static class LowSpaceEventsPublisherFactory
    implements ThreadFactory {
        private final String storageName;

        private LowSpaceEventsPublisherFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB Low Disk Space Publisher (" + this.storageName + ")");
            return thread;
        }
    }

    private static class FlushThreadFactory
    implements ThreadFactory {
        private final String storageName;

        private FlushThreadFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setPriority(10);
            thread.setName("OrientDB Write Cache Flush Task (" + this.storageName + ")");
            return thread;
        }
    }

    private final class RemoveFilePagesTask
    implements Callable<Void> {
        private final int fileId;

        private RemoveFilePagesTask(int fileId) {
            this.fileId = fileId;
        }

        @Override
        public Void call() throws Exception {
            PageKey firstKey = new PageKey(this.fileId, 0L);
            PageKey lastKey = new PageKey(this.fileId, Long.MAX_VALUE);
            this.removeFromRing(OWOWCache.this.writeCachePages.subMap(firstKey, true, lastKey, true));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromRing(NavigableMap<PageKey, PageGroup> subMap) {
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageGroup pageGroup = (PageGroup)entry.getValue();
                PageKey pageKey = (PageKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    OCachePointer pagePointer = pageGroup.page;
                    pagePointer.acquireExclusiveLock();
                    try {
                        pagePointer.decrementWritersReferrer();
                        pagePointer.setWritersListener(null);
                        OWOWCache.this.writeCacheSize.decrement();
                    }
                    finally {
                        pagePointer.releaseExclusiveLock();
                    }
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
        }
    }

    private final class FileFlushTask
    implements Callable<Void> {
        private final int fileId;

        private FileFlushTask(int fileId) {
            this.fileId = fileId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            PageKey firstKey = new PageKey(this.fileId, 0L);
            PageKey lastKey = new PageKey(this.fileId, Long.MAX_VALUE);
            this.flushRing(OWOWCache.this.writeCachePages.subMap(firstKey, true, lastKey, true));
            long finalId = OAbstractWriteCache.composeFileId(OWOWCache.this.id, this.fileId);
            OClosableEntry entry = OWOWCache.this.files.acquire(finalId);
            try {
                ((OFileClassic)entry.get()).synch();
            }
            finally {
                OWOWCache.this.files.release(entry);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushRing(NavigableMap<PageKey, PageGroup> subMap) throws IOException {
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageGroup pageGroup = (PageGroup)entry.getValue();
                PageKey pageKey = (PageKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    OCachePointer pagePointer = pageGroup.page;
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        ByteBuffer buffer = pagePointer.getSharedBuffer();
                        OWOWCache.this.flushPage(pageKey.fileId, pageKey.pageIndex, buffer);
                        OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(buffer);
                        pagePointer.setLastFlushedLsn(flushedLSN);
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    OWOWCache.this.writeCacheSize.decrement();
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
        }
    }

    private final class PeriodicalFuzzyCheckpointTask
    implements Runnable {
        private PeriodicalFuzzyCheckpointTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OSessionStoragePerformanceStatistic statistic = OWOWCache.this.performanceStatisticManager.getSessionPerformanceStatistic();
            if (statistic != null) {
                statistic.startFuzzyCheckpointTimer();
            }
            try {
                OLogSequenceNumber minLsn = this.findMinLsn(OWOWCache.this.writeAheadLog.getFlushedLsn(), OWOWCache.this.writeCachePages);
                if (minLsn == null) {
                    return;
                }
                OLogManager.instance().debug((Object)this, "Start fuzzy checkpoint flushed LSN is %s", minLsn);
                OWOWCache.this.writeAheadLog.logFuzzyCheckPointStart(minLsn);
                for (Integer intId : OWOWCache.this.nameIdMap.values()) {
                    if (intId < 0) continue;
                    long fileId = OAbstractWriteCache.composeFileId(OWOWCache.this.id, intId);
                    OClosableEntry entry = OWOWCache.this.files.acquire(fileId);
                    try {
                        OFileClassic fileClassic = (OFileClassic)entry.get();
                        fileClassic.synch();
                    }
                    finally {
                        OWOWCache.this.files.release(entry);
                    }
                }
                OWOWCache.this.writeAheadLog.logFuzzyCheckPointEnd();
                OWOWCache.this.writeAheadLog.flush();
                if (minLsn.compareTo(new OLogSequenceNumber(-1L, -1L)) > 0) {
                    OWOWCache.this.writeAheadLog.cutTill(minLsn);
                }
                OLogManager.instance().debug((Object)this, "End fuzzy checkpoint", new Object[0]);
            }
            catch (Throwable e) {
                OLogManager.instance().error((Object)this, "Error during fuzzy checkpoint", e, new Object[0]);
                OWOWCache.this.fireBackgroundDataProcessingExceptionEvent(e);
            }
            finally {
                if (statistic != null) {
                    statistic.stopFuzzyCheckpointTimer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OLogSequenceNumber findMinLsn(OLogSequenceNumber minLsn, ConcurrentSkipListMap<PageKey, PageGroup> ring) {
            if (minLsn == null) {
                return null;
            }
            for (Map.Entry<PageKey, PageGroup> entry : ring.entrySet()) {
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry.getKey());
                try {
                    PageGroup group = entry.getValue();
                    OCachePointer pagePointer = group.page;
                    if (pagePointer.getLastFlushedLsn() == null || minLsn.compareTo(pagePointer.getLastFlushedLsn()) <= 0) continue;
                    minLsn = pagePointer.getLastFlushedLsn();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
            return minLsn;
        }
    }

    private final class PeriodicFlushTask
    implements Runnable {
        private PeriodicFlushTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OSessionStoragePerformanceStatistic statistic = OWOWCache.this.performanceStatisticManager.getSessionPerformanceStatistic();
            if (statistic != null) {
                statistic.startWriteCacheFlushTimer();
            }
            int flushedPages = 0;
            boolean iterateByWritePagesFirst = false;
            try {
                double cacheThreshold;
                if (OWOWCache.this.writeCachePages.isEmpty()) {
                    return;
                }
                int writePagesToFlush = 0;
                long wcs = OWOWCache.this.exclusiveWriteCacheSize.get();
                long cs = OWOWCache.this.writeCacheSize.get();
                assert (wcs >= 0L);
                assert (cs >= 0L);
                boolean forceFlush = false;
                double writeCacheThreshold = (double)wcs / (double)OWOWCache.this.writeCacheMaxSize;
                if (writeCacheThreshold > 0.3) {
                    writePagesToFlush = (int)Math.floor((writeCacheThreshold - 0.3) / 0.4 * (double)OWOWCache.this.MAX_PAGES_PER_FLUSH);
                    iterateByWritePagesFirst = true;
                    if (writeCacheThreshold > 0.7) {
                        forceFlush = true;
                    }
                }
                if ((cacheThreshold = (double)cs / (double)OWOWCache.this.cacheMaxSize) > 0.3) {
                    int pagesToFlush = (int)Math.floor((cacheThreshold - 0.3) / 0.4 * (double)OWOWCache.this.MAX_PAGES_PER_FLUSH);
                    writePagesToFlush = Math.max(pagesToFlush, writePagesToFlush);
                    if (cacheThreshold > 0.7) {
                        forceFlush = true;
                    }
                }
                writePagesToFlush = Math.max(4, Math.min(OWOWCache.this.MAX_PAGES_PER_FLUSH, writePagesToFlush));
                OWOWCache.this.lastPageKey = this.findNonExclusivePageKeyWithMinimumLsn().previous();
                OWOWCache.this.lastWritePageKey = this.findExclusivePageKeyWithMinimumLsn().previous();
                flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, iterateByWritePagesFirst);
                if (flushedPages < writePagesToFlush) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, iterateByWritePagesFirst);
                }
                if (flushedPages < writePagesToFlush && iterateByWritePagesFirst) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, false);
                }
                if (flushedPages < writePagesToFlush && forceFlush && (flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, iterateByWritePagesFirst)) < writePagesToFlush && iterateByWritePagesFirst && (flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, false)) < writePagesToFlush) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, false);
                }
            }
            catch (Throwable e) {
                OLogManager.instance().error((Object)this, "Exception during data flush", e, new Object[0]);
                OWOWCache.this.fireBackgroundDataProcessingExceptionEvent(e);
            }
            finally {
                if (statistic != null) {
                    statistic.stopWriteCacheFlushTimer(flushedPages);
                }
            }
        }

        private int flushRing(int writePagesToFlush, int flushedPages, boolean forceFlush, boolean iterateByWritePagesFirst) throws IOException {
            NavigableMap subMap = null;
            NavigableSet<PageKey> writePagesSubset = null;
            if (iterateByWritePagesFirst) {
                writePagesSubset = OWOWCache.this.exclusiveWritePages.tailSet(OWOWCache.this.lastWritePageKey, false);
            } else {
                subMap = OWOWCache.this.writeCachePages.tailMap(OWOWCache.this.lastPageKey, false);
            }
            flushedPages = this.iterateBySubRing(subMap, writePagesSubset, writePagesToFlush, flushedPages, forceFlush, iterateByWritePagesFirst);
            if (flushedPages < writePagesToFlush) {
                flushedPages = this.iterateBySubRing(OWOWCache.this.writeCachePages, OWOWCache.this.exclusiveWritePages, writePagesToFlush, flushedPages, forceFlush, iterateByWritePagesFirst);
            }
            return flushedPages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PageKey findExclusivePageKeyWithMinimumLsn() {
            PageKey result = OWOWCache.this.lastWritePageKey;
            OLogSequenceNumber minimumLsn = new OLogSequenceNumber(Long.MAX_VALUE, Long.MAX_VALUE);
            for (PageKey pageKey : OWOWCache.this.exclusiveWritePages) {
                Lock lock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    OLogSequenceNumber lsn;
                    PageGroup pageGroup = (PageGroup)OWOWCache.this.writeCachePages.get(pageKey);
                    if (pageGroup == null || (lsn = pageGroup.page.getLastFlushedLsn()) == null || lsn.compareTo(minimumLsn) >= 0) continue;
                    minimumLsn = lsn;
                    result = pageKey;
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(lock);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PageKey findNonExclusivePageKeyWithMinimumLsn() {
            PageKey result = OWOWCache.this.lastPageKey;
            OLogSequenceNumber minimumLsn = new OLogSequenceNumber(Long.MAX_VALUE, Long.MAX_VALUE);
            for (Map.Entry entry : OWOWCache.this.writeCachePages.entrySet()) {
                PageKey pageKey = (PageKey)entry.getKey();
                Lock lock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    PageGroup pageGroup = (PageGroup)entry.getValue();
                    OLogSequenceNumber lsn = pageGroup.page.getLastFlushedLsn();
                    if (lsn == null || lsn.compareTo(minimumLsn) >= 0) continue;
                    minimumLsn = lsn;
                    result = pageKey;
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(lock);
                }
            }
            return result;
        }

        private int iterateBySubRing(NavigableMap<PageKey, PageGroup> subMap, NavigableSet<PageKey> subSet, int writePagesToFlush, int flushedWritePages, boolean forceFlush, boolean iterateByWritePagesFirst) throws IOException {
            if (!iterateByWritePagesFirst) {
                return this.iterateByCacheSubRing(subMap, writePagesToFlush, flushedWritePages, forceFlush);
            }
            return this.iterateByWritePagesSubRing(subSet, writePagesToFlush, flushedWritePages, forceFlush);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int iterateByWritePagesSubRing(NavigableSet<PageKey> subSet, int writePagesToFlush, int flushedWritePages, boolean forceFlush) throws IOException {
            Iterator<PageKey> entriesIterator = subSet.iterator();
            long currentTime = System.currentTimeMillis();
            long maxSegmentDistance = OWOWCache.this.writeAheadLog == null ? -1L : (long)((double)OWOWCache.this.writeAheadLog.getPreferredSegmentCount() * 0.75);
            int flushedRegions = 0;
            long lastPageIndex = -1L;
            while (entriesIterator.hasNext()) {
                PageKey entry = entriesIterator.next();
                if (lastPageIndex >= 0L && entry.pageIndex != lastPageIndex + 1L) {
                    ++flushedRegions;
                }
                if (flushedWritePages > writePagesToFlush && flushedRegions >= 4) break;
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry);
                try {
                    boolean weakLockMode;
                    PageGroup group = (PageGroup)OWOWCache.this.writeCachePages.get(entry);
                    if (group == null) {
                        entriesIterator.remove();
                        continue;
                    }
                    OCachePointer pagePointer = group.page;
                    boolean bl = weakLockMode = currentTime - group.creationTime < OWOWCache.this.groupTTL && !forceFlush && !this.tooOldLsn(pagePointer.getLastFlushedLsn(), maxSegmentDistance);
                    if (group.recencyBit && weakLockMode) {
                        group.recencyBit = false;
                        continue;
                    }
                    group.recencyBit = false;
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        ByteBuffer buffer = pagePointer.getSharedBuffer();
                        OWOWCache.this.flushPage(entry.fileId, entry.pageIndex, buffer);
                        OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(buffer);
                        pagePointer.setLastFlushedLsn(flushedLSN);
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    entriesIterator.remove();
                    OWOWCache.this.writeCachePages.remove(entry);
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                    continue;
                }
                OWOWCache.this.lastWritePageKey = entry;
                ++flushedWritePages;
                lastPageIndex = entry.pageIndex;
                OWOWCache.this.writeCacheSize.decrement();
            }
            return flushedWritePages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int iterateByCacheSubRing(NavigableMap<PageKey, PageGroup> subMap, int writePagesToFlush, int flushedWritePages, boolean forceFlush) throws IOException {
            Iterator entriesIterator = subMap.entrySet().iterator();
            long currentTime = System.currentTimeMillis();
            long maxSegmentDistance = OWOWCache.this.writeAheadLog == null ? -1L : (long)((double)OWOWCache.this.writeAheadLog.getPreferredSegmentCount() * 0.75);
            int flushedRegions = 0;
            long lastPageIndex = -1L;
            while (entriesIterator.hasNext()) {
                boolean weakLockMode;
                Map.Entry entry = entriesIterator.next();
                PageGroup group = (PageGroup)entry.getValue();
                PageKey pageKey = (PageKey)entry.getKey();
                if (lastPageIndex >= 0L && pageKey.pageIndex != lastPageIndex + 1L && flushedWritePages > writePagesToFlush && ++flushedRegions >= 4) break;
                OCachePointer pagePointer = group.page;
                boolean bl = weakLockMode = currentTime - group.creationTime < OWOWCache.this.groupTTL && !forceFlush && !this.tooOldLsn(pagePointer.getLastFlushedLsn(), maxSegmentDistance);
                if (group.recencyBit && weakLockMode) {
                    group.recencyBit = false;
                    continue;
                }
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry.getKey());
                try {
                    if (group.recencyBit && weakLockMode) {
                        group.recencyBit = false;
                        continue;
                    }
                    group.recencyBit = false;
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        ByteBuffer buffer = pagePointer.getSharedBuffer();
                        OWOWCache.this.flushPage(pageKey.fileId, pageKey.pageIndex, buffer);
                        OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(buffer);
                        pagePointer.setLastFlushedLsn(flushedLSN);
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    entriesIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                    continue;
                }
                OWOWCache.this.lastPageKey = pageKey;
                ++flushedWritePages;
                lastPageIndex = pageKey.pageIndex;
                OWOWCache.this.writeCacheSize.decrement();
            }
            return flushedWritePages;
        }

        private boolean tooOldLsn(OLogSequenceNumber lsn, long maxSegmentDistance) {
            if (lsn == null || maxSegmentDistance == -1L) {
                return false;
            }
            OLogSequenceNumber walLsn = OWOWCache.this.writeAheadLog.getFlushedLsn();
            return walLsn != null && Math.abs(walLsn.getSegment() - lsn.getSegment()) > maxSegmentDistance;
        }
    }

    private static final class PageKey
    implements Comparable<PageKey> {
        private final int fileId;
        private final long pageIndex;

        private PageKey(int fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        @Override
        public int compareTo(PageKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.pageIndex > other.pageIndex) {
                return 1;
            }
            if (this.pageIndex < other.pageIndex) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (this.fileId != pageKey.fileId) {
                return false;
            }
            return this.pageIndex == pageKey.pageIndex;
        }

        public int hashCode() {
            int result = this.fileId;
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        public String toString() {
            return "PageKey{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }

        public PageKey previous() {
            return this.pageIndex == -1L ? this : new PageKey(this.fileId, this.pageIndex - 1L);
        }
    }

    private static final class NameFileIdEntry {
        private final String name;
        private final int fileId;

        private NameFileIdEntry(String name, int fileId) {
            this.name = name;
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameFileIdEntry that = (NameFileIdEntry)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.fileId;
            return result;
        }
    }
}

