/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport;

import java.sql.SQLException;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.FlywaySqlException;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;

public abstract class SchemaObject {
    protected final JdbcTemplate jdbcTemplate;
    protected final DbSupport dbSupport;
    protected final Schema schema;
    protected final String name;

    public SchemaObject(JdbcTemplate jdbcTemplate, DbSupport dbSupport, Schema schema, String name) {
        this.name = name;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.schema = schema;
    }

    public final Schema getSchema() {
        return this.schema;
    }

    public final String getName() {
        return this.name;
    }

    public final void drop() {
        try {
            this.doDrop();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to drop " + this, e);
        }
    }

    protected abstract void doDrop() throws SQLException;

    public String toString() {
        return this.dbSupport.quote(this.schema.getName(), this.name);
    }
}

