/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa;

import com.orientechnologies.orient.object.jpa.OJPAEntityManager;
import com.orientechnologies.orient.object.jpa.OJPAPersistenceProvider;
import com.orientechnologies.orient.object.jpa.OJPAProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;

public class OJPAEntityManagerFactory
implements EntityManagerFactory {
    private static Logger logger = Logger.getLogger(OJPAPersistenceProvider.class.getName());
    private boolean opened = true;
    private final List<OJPAEntityManager> instances = new ArrayList<OJPAEntityManager>();
    private final OJPAProperties properties;

    public OJPAEntityManagerFactory(OJPAProperties properties) {
        this.properties = properties;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("EntityManagerFactory created. " + this.toString());
        }
    }

    public EntityManager createEntityManager(Map map) {
        return this.createEntityManager(new OJPAProperties(map));
    }

    public EntityManager createEntityManager() {
        return this.createEntityManager(this.properties);
    }

    private EntityManager createEntityManager(OJPAProperties properties) {
        OJPAEntityManager newInstance = new OJPAEntityManager(this, properties);
        this.instances.add(newInstance);
        return newInstance;
    }

    public void close() {
        for (OJPAEntityManager instance : this.instances) {
            instance.close();
        }
        this.instances.clear();
        this.opened = false;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("EntityManagerFactory closed. " + this.toString());
        }
    }

    public boolean isOpen() {
        return this.opened;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        throw new UnsupportedOperationException("getCriteriaBuilder");
    }

    public Metamodel getMetamodel() {
        throw new UnsupportedOperationException("getMetamodel");
    }

    public Map<String, Object> getProperties() {
        return this.properties.getUnmodifiableProperties();
    }

    public Cache getCache() {
        throw new UnsupportedOperationException("getCache");
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        throw new UnsupportedOperationException("getPersistenceUnitUtil");
    }
}

