/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.samplers;

import com.uber.jaeger.exceptions.SamplingStrategyErrorException;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.NullStatsReporter;
import com.uber.jaeger.metrics.StatsFactoryImpl;
import com.uber.jaeger.samplers.HttpSamplingManager;
import com.uber.jaeger.samplers.PerOperationSampler;
import com.uber.jaeger.samplers.ProbabilisticSampler;
import com.uber.jaeger.samplers.RateLimitingSampler;
import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.samplers.SamplingManager;
import com.uber.jaeger.samplers.SamplingStatus;
import com.uber.jaeger.samplers.http.OperationSamplingParameters;
import com.uber.jaeger.samplers.http.ProbabilisticSamplingStrategy;
import com.uber.jaeger.samplers.http.RateLimitingSamplingStrategy;
import com.uber.jaeger.samplers.http.SamplingStrategyResponse;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteControlledSampler
implements Sampler {
    private static final Logger log = LoggerFactory.getLogger(RemoteControlledSampler.class);
    public static final String TYPE = "remote";
    private static final int DEFAULT_POLLING_INTERVAL_MS = 60000;
    private final int maxOperations = 2000;
    private final String serviceName;
    private final SamplingManager manager;
    private final Timer pollTimer;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Metrics metrics;
    private Sampler sampler;

    @Deprecated
    public RemoteControlledSampler(String serviceName, SamplingManager manager, Sampler initial, Metrics metrics) {
        this(new Builder(serviceName).withSamplingManager(manager).withInitialSampler(initial).withMetrics(metrics));
    }

    @Deprecated
    public RemoteControlledSampler(String serviceName, SamplingManager manager, Sampler initial, Metrics metrics, int pollingIntervalMs) {
        this(new Builder(serviceName).withSamplingManager(manager).withInitialSampler(initial).withMetrics(metrics).withPollingInterval(pollingIntervalMs));
    }

    private RemoteControlledSampler(Builder builder) {
        this.serviceName = builder.serviceName;
        this.manager = builder.samplingManager;
        this.metrics = builder.metrics;
        this.sampler = builder.initialSampler != null ? builder.initialSampler : new ProbabilisticSampler(0.001);
        this.pollTimer = new Timer(true);
        this.pollTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RemoteControlledSampler.this.updateSampler();
            }
        }, 0L, (long)builder.poolingIntervalMs);
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    void updateSampler() {
        SamplingStrategyResponse response;
        try {
            response = this.manager.getSamplingStrategy(this.serviceName);
            this.metrics.samplerRetrieved.inc(1L);
        }
        catch (SamplingStrategyErrorException e) {
            this.metrics.samplerQueryFailure.inc(1L);
            return;
        }
        if (response.getOperationSampling() != null) {
            this.updatePerOperationSampler(response.getOperationSampling());
        } else {
            this.updateRateLimitingOrProbabilisticSampler(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRateLimitingOrProbabilisticSampler(SamplingStrategyResponse response) {
        Sampler sampler;
        Object strategy;
        if (response.getProbabilisticSampling() != null) {
            strategy = response.getProbabilisticSampling();
            sampler = new ProbabilisticSampler(((ProbabilisticSamplingStrategy)strategy).getSamplingRate());
        } else if (response.getRateLimitingSampling() != null) {
            strategy = response.getRateLimitingSampling();
            sampler = new RateLimitingSampler(((RateLimitingSamplingStrategy)strategy).getMaxTracesPerSecond());
        } else {
            this.metrics.samplerParsingFailure.inc(1L);
            log.error("No strategy present in response. Not updating sampler.");
            return;
        }
        RemoteControlledSampler remoteControlledSampler = this;
        synchronized (remoteControlledSampler) {
            if (!this.sampler.equals(sampler)) {
                this.sampler = sampler;
                this.metrics.samplerUpdated.inc(1L);
            }
        }
    }

    private synchronized void updatePerOperationSampler(OperationSamplingParameters samplingParameters) {
        if (this.sampler instanceof PerOperationSampler) {
            if (((PerOperationSampler)this.sampler).update(samplingParameters)) {
                this.metrics.samplerUpdated.inc(1L);
            }
        } else {
            this.sampler = new PerOperationSampler(2000, samplingParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamplingStatus sample(String operation, long id) {
        RemoteControlledSampler remoteControlledSampler = this;
        synchronized (remoteControlledSampler) {
            return this.sampler.sample(operation, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object sampler) {
        if (this == sampler) {
            return true;
        }
        if (sampler instanceof RemoteControlledSampler) {
            RemoteControlledSampler remoteSampler = (RemoteControlledSampler)sampler;
            RemoteControlledSampler remoteControlledSampler = this;
            synchronized (remoteControlledSampler) {
                boolean bl;
                ReentrantReadWriteLock.ReadLock readLock = remoteSampler.getLock().readLock();
                readLock.lock();
                try {
                    bl = this.sampler.equals(remoteSampler.sampler);
                    readLock.unlock();
                }
                catch (Throwable throwable) {
                    readLock.unlock();
                    throw throwable;
                }
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RemoteControlledSampler remoteControlledSampler = this;
        synchronized (remoteControlledSampler) {
            this.pollTimer.cancel();
        }
    }

    public String toString() {
        return "RemoteControlledSampler(maxOperations=" + this.maxOperations + ", serviceName=" + this.serviceName + ", manager=" + this.manager + ", metrics=" + this.metrics + ", sampler=" + this.getSampler() + ")";
    }

    Sampler getSampler() {
        return this.sampler;
    }

    public static class Builder {
        private final String serviceName;
        private SamplingManager samplingManager;
        private Sampler initialSampler;
        private Metrics metrics;
        private int poolingIntervalMs = 60000;

        public Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        public Builder withSamplingManager(SamplingManager samplingManager) {
            this.samplingManager = samplingManager;
            return this;
        }

        public Builder withInitialSampler(Sampler initialSampler) {
            this.initialSampler = initialSampler;
            return this;
        }

        public Builder withMetrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder withPollingInterval(int pollingIntervalMs) {
            this.poolingIntervalMs = pollingIntervalMs;
            return this;
        }

        public RemoteControlledSampler build() {
            if (this.samplingManager == null) {
                this.samplingManager = new HttpSamplingManager();
            }
            if (this.initialSampler == null) {
                this.initialSampler = new ProbabilisticSampler(0.001);
            }
            if (this.metrics == null) {
                this.metrics = new Metrics(new StatsFactoryImpl(new NullStatsReporter()));
            }
            return new RemoteControlledSampler(this);
        }
    }
}

