/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.zipkin.gen;

import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.SpanCodec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zipkin.BinaryAnnotation;
import zipkin.Span;

public class Span
implements Serializable {
    static final long serialVersionUID = 1L;
    public volatile Long startTick;
    private long trace_id;
    private String name;
    private long id;
    private Long parent_id;
    private List<Annotation> annotations = Collections.emptyList();
    private List<BinaryAnnotation> binary_annotations = Collections.emptyList();
    private Boolean debug;
    private Long timestamp;
    private Long duration;

    public long getTrace_id() {
        return this.trace_id;
    }

    public Span setTrace_id(long trace_id) {
        this.trace_id = trace_id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Span setName(String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        this.name = name;
        return this;
    }

    public long getId() {
        return this.id;
    }

    public Span setId(long id) {
        this.id = id;
        return this;
    }

    public Long getParent_id() {
        return this.parent_id;
    }

    public Span setParent_id(Long parent_id) {
        this.parent_id = parent_id;
        return this;
    }

    public Span addToAnnotations(Annotation elem) {
        if (this.annotations == Collections.EMPTY_LIST) {
            this.annotations = new ArrayList<Annotation>();
        }
        this.annotations.add(elem);
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Span setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Span addToBinary_annotations(BinaryAnnotation elem) {
        if (this.binary_annotations == Collections.EMPTY_LIST) {
            this.binary_annotations = new ArrayList<BinaryAnnotation>();
        }
        this.binary_annotations.add(elem);
        return this;
    }

    public List<BinaryAnnotation> getBinary_annotations() {
        return this.binary_annotations;
    }

    public Span setBinaryAnnotations(List<BinaryAnnotation> binary_annotations) {
        this.binary_annotations = binary_annotations;
        return this;
    }

    public Boolean isDebug() {
        return this.debug;
    }

    public Span setDebug(Boolean debug) {
        this.debug = debug;
        return this;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Span setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Span setDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Span) {
            Span that = (Span)o;
            return this.trace_id == that.trace_id && this.name.equals(that.name) && this.id == that.id && Util.equal(this.parent_id, that.parent_id) && Util.equal(this.timestamp, that.timestamp) && Util.equal(this.duration, that.duration) && Util.equal(this.annotations, that.annotations) && Util.equal(this.binary_annotations, that.binary_annotations) && Util.equal(this.debug, that.debug);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (this.trace_id >>> 32 ^ this.trace_id));
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.id >>> 32 ^ this.id));
        h *= 1000003;
        h ^= this.parent_id == null ? 0 : this.parent_id.hashCode();
        h *= 1000003;
        h ^= this.timestamp == null ? 0 : this.timestamp.hashCode();
        h *= 1000003;
        h ^= this.duration == null ? 0 : this.duration.hashCode();
        h *= 1000003;
        h ^= this.annotations == null ? 0 : this.annotations.hashCode();
        h *= 1000003;
        h ^= this.binary_annotations == null ? 0 : this.binary_annotations.hashCode();
        h *= 1000003;
        return h ^= this.debug == null ? 0 : this.debug.hashCode();
    }

    public String toString() {
        return new String(SpanCodec.JSON.writeSpan(this), Util.UTF_8);
    }

    public zipkin.Span toZipkin() {
        Span.Builder result = zipkin.Span.builder();
        result.traceId(this.getTrace_id());
        result.id(this.getId());
        result.parentId(this.getParent_id());
        result.name(this.getName());
        result.timestamp(this.getTimestamp());
        result.duration(this.getDuration());
        result.debug(this.isDebug());
        for (Annotation annotation : this.getAnnotations()) {
            result.addAnnotation(zipkin.Annotation.create((long)annotation.timestamp, (String)annotation.value, (zipkin.Endpoint)Span.from(annotation.host)));
        }
        for (BinaryAnnotation binaryAnnotation : this.getBinary_annotations()) {
            result.addBinaryAnnotation(zipkin.BinaryAnnotation.builder().key(binaryAnnotation.key).value(binaryAnnotation.value).type(BinaryAnnotation.Type.fromValue((int)binaryAnnotation.type.getValue())).endpoint(Span.from(binaryAnnotation.host)).build());
        }
        return result.build();
    }

    private static zipkin.Endpoint from(Endpoint host) {
        if (host == null) {
            return null;
        }
        return zipkin.Endpoint.builder().ipv4(host.ipv4).ipv6(host.ipv6).port(host.port).serviceName(host.service_name).build();
    }
}

