/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.mongodb.Mongo;
import org.wildfly.swarm.config.mongodb.MongoConsumer;
import org.wildfly.swarm.config.mongodb.MongoSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=mongodb")
@ResourceType(value="subsystem")
@Implicit
public class Mongodb<T extends Mongodb<T>>
implements Keyed {
    private String key = "mongodb";
    private PropertyChangeSupport pcs;
    private MongodbResources subresources = new MongodbResources();

    public Mongodb() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public MongodbResources subresources() {
        return this.subresources;
    }

    public T mongos(List<Mongo> value) {
        this.subresources.mongos = value;
        return (T)this;
    }

    public T mongo(Mongo value) {
        this.subresources.mongos.add(value);
        return (T)this;
    }

    public T mongo(String childKey, MongoConsumer consumer) {
        Mongo child = new Mongo(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.mongo(child);
        return (T)this;
    }

    public T mongo(String childKey) {
        this.mongo(childKey, null);
        return (T)this;
    }

    public T mongo(MongoSupplier supplier) {
        this.mongo(supplier.get());
        return (T)this;
    }

    public static class MongodbResources {
        @ResourceDocumentation(value="MongoDB server definition")
        @SubresourceInfo(value="mongo")
        private List<Mongo> mongos = new ArrayList<Mongo>();

        @Subresource
        public List<Mongo> mongos() {
            return this.mongos;
        }

        public Mongo mongo(String key) {
            return this.mongos.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

