/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;

public abstract class Position {
    protected final double[] coords;

    protected Position(double ... coords) {
        if (coords.length == 0) {
            this.coords = new double[0];
        } else {
            double[] c = new double[this.getCoordinateDimension()];
            System.arraycopy(coords, 0, c, 0, coords.length);
            this.coords = c;
        }
    }

    public double[] toArray(double[] dest) {
        if (this.isEmpty()) {
            return new double[0];
        }
        int dim = this.getCoordinateDimension();
        if (dest == null || dest.length < dim) {
            dest = new double[dim];
        }
        System.arraycopy(this.coords, 0, dest, 0, dim);
        return dest;
    }

    public abstract int getCoordinateDimension();

    public boolean isEmpty() {
        return this.coords.length == 0;
    }

    public double getCoordinate(int idx) {
        return this.isEmpty() ? Double.NaN : this.coords[idx];
    }

    public double getCoordinate(CoordinateSystemAxis axis, CoordinateReferenceSystem<?> crs) {
        int idx = crs.getAxisIndex(axis);
        if (idx == -1) {
            throw new IllegalArgumentException("Not an axis of this coordinate reference system.");
        }
        return this.getCoordinate(axis.getNormalOrder());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position position = (Position)o;
        return Arrays.equals(this.coords, position.toArray(null));
    }

    public int hashCode() {
        return Arrays.hashCode(this.coords);
    }

    public String toString() {
        return Arrays.toString(this.coords);
    }
}

