/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.parser;

import com.orientechnologies.common.parser.OVariableParser;
import com.orientechnologies.common.parser.OVariableParserListener;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OSystemVariableResolver
implements OVariableParserListener {
    public static final String VAR_BEGIN = "${";
    public static final String VAR_END = "}";
    private static OSystemVariableResolver instance = new OSystemVariableResolver();

    public static String resolveSystemVariables(String iPath) {
        return OSystemVariableResolver.resolveSystemVariables(iPath, null);
    }

    public static String resolveSystemVariables(String iPath, String iDefault) {
        if (iPath == null) {
            return iDefault;
        }
        return (String)OVariableParser.resolveVariables(iPath, VAR_BEGIN, VAR_END, instance, iDefault);
    }

    public static String resolveVariable(String variable) {
        if (variable == null) {
            return null;
        }
        String resolved = System.getProperty(variable);
        if (resolved == null) {
            resolved = System.getenv(variable);
        }
        return resolved;
    }

    @Override
    public String resolve(String variable) {
        return OSystemVariableResolver.resolveVariable(variable);
    }

    public static void setEnv(String name, String value) {
        HashMap<String, String> map = new HashMap<String, String>(System.getenv());
        map.put(name, value);
        OSystemVariableResolver.setEnv(map);
    }

    public static void setEnv(Map<String, String> newenv) {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newenv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newenv);
        }
        catch (NoSuchFieldException e) {
            try {
                Class<?>[] classes = Collections.class.getDeclaredClasses();
                Map<String, String> env = System.getenv();
                for (Class<?> cl : classes) {
                    if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                    Field field = cl.getDeclaredField("m");
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                    map.putAll(newenv);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

