/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.nio.ByteBuffer;

public class OWALPage {
    public static final long MAGIC_NUMBER = 4207608830L;
    public static final int PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    public static final int MIN_RECORD_SIZE = 7;
    public static final int CRC_OFFSET = 0;
    public static final int MAGIC_NUMBER_OFFSET = 4;
    public static final int FREE_SPACE_OFFSET = 12;
    public static final int RECORDS_OFFSET = 16;
    public static final int MAX_ENTRY_SIZE = PAGE_SIZE - 16;
    private final ByteBuffer buffer;

    public OWALPage(ByteBuffer buffer, boolean isNew) {
        this.buffer = buffer;
        if (isNew) {
            buffer.position(4);
            buffer.putLong(4207608830L);
            buffer.putInt(MAX_ENTRY_SIZE);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public int appendRecord(byte[] content, boolean mergeWithNextPage, boolean recordTail) {
        int freeSpace = this.getFreeSpace();
        int freePosition = PAGE_SIZE - freeSpace;
        this.buffer.position(freePosition);
        this.buffer.put(mergeWithNextPage ? (byte)1 : 0);
        this.buffer.put(recordTail ? (byte)1 : 0);
        this.buffer.putInt(content.length);
        this.buffer.put(content);
        this.buffer.position(12);
        this.buffer.putInt(12, freeSpace - 2 - 4 - content.length);
        return freePosition;
    }

    public byte[] getRecord(int position) {
        this.buffer.position(position + 2);
        int recordSize = this.buffer.getInt();
        byte[] record = new byte[recordSize];
        this.buffer.get(record);
        return record;
    }

    public int getSerializedRecordSize(int position) {
        int recordSize = this.buffer.getInt(position + 2);
        return recordSize + 4 + 2;
    }

    public boolean mergeWithNextPage(int position) {
        return this.buffer.get(position) > 0;
    }

    public boolean isEmpty() {
        return this.getFreeSpace() == MAX_ENTRY_SIZE;
    }

    public int getFreeSpace() {
        return this.buffer.getInt(12);
    }

    public int getFilledUpTo() {
        return PAGE_SIZE - this.getFreeSpace();
    }

    public static int calculateSerializedSize(int recordSize) {
        return recordSize + 4 + 2;
    }

    public static int calculateRecordSize(int serializedSize) {
        return serializedSize - 4 - 2;
    }
}

