/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers.mysql;

import org.apache.activemq.artemis.jdbc.store.sql.GenericSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public class MySQLSQLProvider
extends GenericSQLProvider {
    private static final long MAX_BLOB_SIZE = 0L;
    private final String createFileTableSQL;
    private final String[] createJournalTableSQL;
    private final String copyFileRecordByIdSQL;

    private MySQLSQLProvider(String tName, SQLProvider.DatabaseStoreType databaseStoreType) {
        super(tName.toLowerCase(), databaseStoreType);
        this.createFileTableSQL = "CREATE TABLE " + this.tableName + "(ID BIGINT NOT NULL AUTO_INCREMENT," + "FILENAME VARCHAR(255), EXTENSION VARCHAR(10), DATA LONGBLOB, PRIMARY KEY(ID)) ENGINE=InnoDB;";
        this.createJournalTableSQL = new String[]{"CREATE TABLE " + this.tableName + "(id BIGINT,recordType SMALLINT,compactCount SMALLINT,txId BIGINT,userRecordType SMALLINT,variableSize INTEGER,record LONGBLOB,txDataSize INTEGER,txData LONGBLOB,txCheckNoRecords INTEGER,seq BIGINT) ENGINE=InnoDB;", "CREATE INDEX " + this.tableName + "_IDX ON " + this.tableName + " (id)"};
        this.copyFileRecordByIdSQL = " UPDATE " + this.tableName + ", (SELECT DATA AS FROM_DATA FROM " + this.tableName + " WHERE id=?) SELECT_COPY SET DATA=FROM_DATA WHERE id=?;";
    }

    @Override
    public long getMaxBlobSize() {
        return 0L;
    }

    @Override
    public String getCreateFileTableSQL() {
        return this.createFileTableSQL;
    }

    @Override
    public String[] getCreateJournalTableSQL() {
        return this.createJournalTableSQL;
    }

    @Override
    public String getCopyFileRecordByIdSQL() {
        return this.copyFileRecordByIdSQL;
    }

    public static class Factory
    implements SQLProvider.Factory {
        @Override
        public SQLProvider create(String tableName, SQLProvider.DatabaseStoreType databaseStoreType) {
            return new MySQLSQLProvider(tableName, databaseStoreType);
        }
    }
}

