/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionIdGenerator;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.MappedValueService;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.web.undertow.UndertowUnaryRequirement;
import org.wildfly.extension.undertow.Server;

public class SessionIdGeneratorBuilder
implements CapabilityServiceBuilder<SessionIdGenerator> {
    private final ServiceName name;
    private final String serverName;
    private volatile ValueDependency<Server> server;

    public SessionIdGeneratorBuilder(ServiceName name, String serverName) {
        this.name = name;
        this.serverName = serverName;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<SessionIdGenerator> configure(CapabilityServiceSupport support) {
        this.server = new InjectedValueDependency(UndertowUnaryRequirement.SERVER.getServiceName(support, this.serverName), Server.class);
        return this;
    }

    public ServiceBuilder<SessionIdGenerator> build(ServiceTarget target) {
        Function<Server, SessionIdGenerator> mapper = server -> {
            SecureRandomSessionIdGenerator generator = new SecureRandomSessionIdGenerator();
            generator.setLength(server.getServletContainer().getSessionIdLength());
            return generator;
        };
        MappedValueService service = new MappedValueService(mapper, this.server);
        return this.server.register(target.addService(this.getServiceName(), (Service)service));
    }
}

