/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageProducer;
import org.apache.activemq.artemis.ra.ActiveMQRASession;

public class ActiveMQRAQueueSender
extends ActiveMQRAMessageProducer
implements QueueSender {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();

    public ActiveMQRAQueueSender(QueueSender producer, ActiveMQRASession session) {
        super((MessageProducer)producer, session);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + producer + ", " + session + ")");
        }
    }

    public Queue getQueue() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getQueue()");
        }
        return ((QueueSender)this.producer).getQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Queue destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("send " + this + " destination=" + destination + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive);
            }
            this.checkState();
            this.producer.send((Destination)destination, message, deliveryMode, priority, timeToLive);
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public void send(Queue destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("send " + this + " destination=" + destination + " message=" + message);
            }
            this.checkState();
            this.producer.send((Destination)destination, message);
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }
}

