/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.ListenerRegistry;
import io.undertow.server.OpenListener;
import io.undertow.server.protocol.http.AlpnOpenListener;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.server.protocol.http2.Http2OpenListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.network.NetworkUtils;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.SslConnection;

public class HttpsListenerService
extends HttpListenerService {
    private Supplier<SSLContext> sslContextSupplier;
    private volatile AcceptingChannel<SslConnection> sslServer;
    static final String PROTOCOL = "https";
    private final String cipherSuites;

    public HttpsListenerService(String name, String serverName, OptionMap listenerOptions, String cipherSuites, OptionMap socketOptions) {
        this(name, serverName, listenerOptions, cipherSuites, socketOptions, false, false);
    }

    HttpsListenerService(String name, String serverName, OptionMap listenerOptions, String cipherSuites, OptionMap socketOptions, boolean certificateForwarding, boolean proxyAddressForwarding) {
        super(name, serverName, listenerOptions, socketOptions, certificateForwarding, proxyAddressForwarding);
        this.cipherSuites = cipherSuites;
    }

    void setSSLContextSupplier(Supplier<SSLContext> sslContextSupplier) {
        this.sslContextSupplier = sslContextSupplier;
    }

    @Override
    protected OpenListener createOpenListener() {
        if (this.listenerOptions.get(UndertowOptions.ENABLE_HTTP2, false)) {
            try {
                return this.createAlpnOpenListener();
            }
            catch (Throwable e) {
                UndertowLogger.ROOT_LOGGER.alpnNotFound(this.getName());
                UndertowLogger.ROOT_LOGGER.debug("Exception creating ALPN listener", e);
                return super.createOpenListener();
            }
        }
        return super.createOpenListener();
    }

    private OpenListener createAlpnOpenListener() {
        OptionMap undertowOptions = OptionMap.builder().addAll(commonOptions).addAll(this.listenerOptions).set(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, this.getUndertowService().isStatisticsEnabled()).getMap();
        Pool bufferPool = (Pool)this.getBufferPool().getValue();
        HttpOpenListener http = new HttpOpenListener(bufferPool, undertowOptions);
        AlpnOpenListener alpn = new AlpnOpenListener(bufferPool, undertowOptions, (DelegateOpenListener)http);
        if (this.listenerOptions.get(UndertowOptions.ENABLE_HTTP2, false)) {
            Http2OpenListener http2 = new Http2OpenListener(bufferPool, undertowOptions, "h2");
            alpn.addProtocol("h2", (DelegateOpenListener)http2, 10);
            Http2OpenListener http2_14 = new Http2OpenListener(bufferPool, undertowOptions, "h2-14");
            alpn.addProtocol("h2-14", (DelegateOpenListener)http2_14, 9);
        }
        return alpn;
    }

    @Override
    protected void startListening(XnioWorker worker, InetSocketAddress socketAddress, ChannelListener<AcceptingChannel<StreamConnection>> acceptListener) throws IOException {
        SSLContext sslContext = this.sslContextSupplier.get();
        OptionMap.Builder builder = OptionMap.builder().addAll(commonOptions);
        builder.addAll(this.socketOptions);
        builder.set(Options.USE_DIRECT_BUFFERS, true);
        if (this.cipherSuites != null) {
            Object[] cipherList = CipherSuiteSelector.fromString((String)this.cipherSuites).evaluate(sslContext.getSupportedSSLParameters().getCipherSuites());
            builder.setSequence(HttpsListenerResourceDefinition.ENABLED_CIPHER_SUITES.getOption(), cipherList);
        }
        OptionMap combined = builder.getMap();
        UndertowXnioSsl xnioSsl = new UndertowXnioSsl(worker.getXnio(), combined, sslContext);
        this.sslServer = xnioSsl.createSslConnectionServer(worker, socketAddress, acceptListener, combined);
        this.sslServer.resumeAccepts();
        InetSocketAddress boundAddress = (InetSocketAddress)this.sslServer.getLocalAddress(InetSocketAddress.class);
        UndertowLogger.ROOT_LOGGER.listenerStarted("HTTPS", this.getName(), NetworkUtils.formatIPAddressForURI((InetAddress)boundAddress.getAddress()), boundAddress.getPort());
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    protected void stopListening() {
        InetSocketAddress boundAddress = (InetSocketAddress)this.sslServer.getLocalAddress(InetSocketAddress.class);
        this.sslServer.suspendAccepts();
        UndertowLogger.ROOT_LOGGER.listenerSuspend("HTTPS", this.getName());
        IoUtils.safeClose(this.sslServer);
        this.sslServer = null;
        UndertowLogger.ROOT_LOGGER.listenerStopped("HTTPS", this.getName(), NetworkUtils.formatIPAddressForURI((InetAddress)boundAddress.getAddress()), boundAddress.getPort());
        ((ListenerRegistry)this.httpListenerRegistry.getValue()).removeListener(this.getName());
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }
}

