/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.ArrayTemplateBuilder;
import org.msgpack.template.builder.OrdinalEnumTemplateBuilder;
import org.msgpack.template.builder.ReflectionBeansTemplateBuilder;
import org.msgpack.template.builder.ReflectionTemplateBuilder;
import org.msgpack.template.builder.TemplateBuilder;
import org.msgpack.util.android.DalvikVmChecker;

public class TemplateBuilderChain {
    private static final String JAVASSIST_TEMPLATE_BUILDER_CLASS_NAME = "org.msgpack.template.builder.JavassistTemplateBuilder";
    private static final String REFLECTION_TEMPLATE_BUILDER_CLASS_NAME = "org.msgpack.template.builder.ReflectionTemplateBuilder";
    protected List<TemplateBuilder> templateBuilders = new ArrayList<TemplateBuilder>();
    protected TemplateBuilder forceBuilder;

    private static boolean enableDynamicCodeGeneration() {
        return !DalvikVmChecker.isDalvikVm();
    }

    public TemplateBuilderChain(TemplateRegistry registry) {
        this(registry, null);
    }

    public TemplateBuilderChain(TemplateRegistry registry, ClassLoader cl) {
        this.reset(registry, cl);
    }

    protected void reset(TemplateRegistry registry, ClassLoader cl) {
        if (registry == null) {
            throw new NullPointerException("registry is null");
        }
        String forceBuilderClassName = null;
        forceBuilderClassName = TemplateBuilderChain.enableDynamicCodeGeneration() ? JAVASSIST_TEMPLATE_BUILDER_CLASS_NAME : REFLECTION_TEMPLATE_BUILDER_CLASS_NAME;
        TemplateBuilder builder = this.forceBuilder = TemplateBuilderChain.createForceTemplateBuilder(forceBuilderClassName, registry, cl);
        this.templateBuilders.add(new ArrayTemplateBuilder(registry));
        this.templateBuilders.add(new OrdinalEnumTemplateBuilder(registry));
        this.templateBuilders.add(builder);
        this.templateBuilders.add(new ReflectionBeansTemplateBuilder(registry));
    }

    private static TemplateBuilder createForceTemplateBuilder(String className, TemplateRegistry registry, ClassLoader cl) {
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> cons = c.getConstructor(TemplateRegistry.class, ClassLoader.class);
            return (TemplateBuilder)cons.newInstance(registry, cl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReflectionTemplateBuilder(registry, cl);
        }
    }

    public TemplateBuilder getForceBuilder() {
        return this.forceBuilder;
    }

    public TemplateBuilder select(Type targetType, boolean hasAnnotation) {
        for (TemplateBuilder tb : this.templateBuilders) {
            if (!tb.matchType(targetType, hasAnnotation)) continue;
            return tb;
        }
        return null;
    }
}

