/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.orientdb.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.wildfly.swarm.container.util.Messages;
import org.wildfly.swarm.orientdb.OrientDBFraction;
import org.wildfly.swarm.orientdb.runtime.OrientDBDriverInfo;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Pre
@ApplicationScoped
public class OrientDBCustomizer
implements Customizer {
    @Inject
    @Any
    Instance<OrientDBFraction> allDrivers;

    public void customize() throws Exception {
        this.customizeDrivers();
    }

    protected void customizeDrivers() {
        this.allDrivers.forEach(this::attemptInstallation);
    }

    protected void attemptInstallation(OrientDBFraction info) {
        OrientDBDriverInfo orientDBDriverInfo = new OrientDBDriverInfo();
        if (orientDBDriverInfo.detect(info)) {
            Messages.MESSAGES.autodetectedDriver(orientDBDriverInfo.name());
        }
    }
}

