/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.binary;

import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;

public class OAsynchChannelServiceThread
extends OSoftThread {
    private OChannelBinaryAsynchClient network;
    private int sessionId = Integer.MIN_VALUE;
    private ORemoteServerEventListener remoteServerEventListener;

    public OAsynchChannelServiceThread(ORemoteServerEventListener iRemoteServerEventListener, OChannelBinaryAsynchClient iChannel) {
        super(Orient.instance().getThreadGroup(), "OrientDB <- Asynch Client (" + iChannel.socket.getRemoteSocketAddress() + ")");
        this.remoteServerEventListener = iRemoteServerEventListener;
        this.network = iChannel;
        this.start();
    }

    protected void execute() throws Exception {
        try {
            this.network.beginResponse(this.sessionId, 0L, false);
            byte[] obj = null;
            byte request = this.network.readByte();
            switch (request) {
                case 80: 
                case 81: {
                    obj = this.network.readBytes();
                }
            }
            if (this.remoteServerEventListener != null) {
                this.remoteServerEventListener.onRequest(request, (Object)obj);
            }
        }
        catch (IOException ioe) {
            this.sendShutdown();
            if (this.network != null) {
                OChannelBinaryAsynchClient n = this.network;
                this.network = null;
                n.close();
            }
        }
        finally {
            if (this.network != null) {
                this.network.endResponse();
            }
        }
    }
}

