/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getClassLoader(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }
        });
    }

    static void load(final String lib) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.load(lib);
                return null;
            }
        });
    }

    static Method[] getMethods(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getMethods();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return c.getMethods();
            }
        });
    }

    static void setAccessible(final AccessibleObject ao) {
        if (System.getSecurityManager() == null) {
            ao.setAccessible(true);
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ao.setAccessible(true);
                return null;
            }
        });
    }
}

