/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import zipkin.internal.Lazy;
import zipkin.internal.Util;

public abstract class LazyCloseable<T>
extends Lazy<T>
implements Closeable {
    final long exceptionExpirationDuration = TimeUnit.SECONDS.toNanos(1L);
    RuntimeException lastException;
    long exceptionExpiration;

    @Override
    T tryCompute() {
        if (this.lastException != null) {
            if (this.exceptionExpiration - this.nanoTime() <= 0L) {
                this.lastException = null;
            } else {
                throw this.lastException;
            }
        }
        try {
            return this.compute();
        }
        catch (RuntimeException e) {
            this.lastException = e;
            this.exceptionExpiration = this.nanoTime() + this.exceptionExpirationDuration;
            throw e;
        }
    }

    long nanoTime() {
        return System.nanoTime();
    }

    @Override
    public void close() throws IOException {
        T maybeNull = this.maybeNull();
        if (maybeNull != null) {
            Util.checkArgument(maybeNull instanceof Closeable, "Override close() to close " + maybeNull, new Object[0]);
            ((Closeable)maybeNull).close();
        }
    }

    protected final T maybeNull() {
        return (T)this.instance;
    }
}

