/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark;

import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mvc.MvcContext;
import javax.mvc.MvcUriBuilder;
import javax.mvc.security.Csrf;
import javax.mvc.security.Encoders;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Configuration;
import org.mvcspec.ozark.jaxrs.JaxRsContext;
import org.mvcspec.ozark.servlet.OzarkContainerInitializer;
import org.mvcspec.ozark.uri.ApplicationUris;
import org.mvcspec.ozark.util.PathUtils;

@Named(value="mvc")
@RequestScoped
public class MvcContextImpl
implements MvcContext {
    private static final Logger log = Logger.getLogger(MvcContextImpl.class.getName());
    @Inject
    private Csrf csrf;
    @Inject
    private Encoders encoders;
    @Inject
    private ServletContext servletContext;
    @Inject
    private ApplicationUris applicationUris;
    @Inject
    @JaxRsContext
    private Configuration configuration;
    private Locale locale;
    private String applicationPath;

    @PostConstruct
    public void init() {
        Object appPath = this.servletContext.getAttribute(OzarkContainerInitializer.APP_PATH_CONTEXT_KEY);
        if (appPath != null) {
            this.applicationPath = PathUtils.normalizePath(appPath.toString());
        } else {
            log.warning("Unable to detect application path. This means that ${mvc.applicationPath} and ${mvc.basePath} will not work correctly");
        }
        if (this.configuration == null) {
            throw new IllegalArgumentException("Cannot obtain JAX-RS Configuration instance");
        }
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public String getBasePath() {
        if (this.getApplicationPath() != null) {
            return this.getContextPath() + this.getApplicationPath();
        }
        return this.getContextPath();
    }

    public Csrf getCsrf() {
        return this.csrf;
    }

    public Encoders getEncoders() {
        return this.encoders;
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public URI uri(String identifier) {
        return this.applicationUris.get(identifier);
    }

    public URI uri(String identifier, Map<String, Object> params) {
        return this.applicationUris.get(identifier, params);
    }

    public MvcUriBuilder uriBuilder(String identifier) {
        return this.applicationUris.getUriBuilder(identifier);
    }
}

