/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.ozark.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.Vetoed;
import javax.mvc.binding.BindingError;
import javax.mvc.binding.BindingResult;
import javax.mvc.binding.ValidationError;

@Vetoed
public class BindingResultImpl
implements BindingResult {
    private final Set<BindingError> bindingErrors = new LinkedHashSet<BindingError>();
    private final Set<ValidationError> validationErrors = new LinkedHashSet<ValidationError>();
    private boolean consumed;

    public boolean isFailed() {
        this.consumed = true;
        return this.validationErrors.size() > 0 || this.bindingErrors.size() > 0;
    }

    public List<String> getAllMessages() {
        this.consumed = true;
        ArrayList<String> result = new ArrayList<String>();
        this.bindingErrors.forEach(error -> result.add(error.getMessage()));
        this.validationErrors.forEach(violation -> result.add(violation.getMessage()));
        return result;
    }

    public Set<BindingError> getAllBindingErrors() {
        this.consumed = true;
        return this.bindingErrors;
    }

    public BindingError getBindingError(String param) {
        this.consumed = true;
        for (BindingError error : this.bindingErrors) {
            if (!param.equals(error.getParamName())) continue;
            return error;
        }
        return null;
    }

    public Set<ValidationError> getAllValidationErrors() {
        this.consumed = true;
        return Collections.unmodifiableSet(this.validationErrors);
    }

    public Set<ValidationError> getValidationErrors(String param) {
        this.consumed = true;
        return this.validationErrors.stream().filter(ve -> Objects.equals(ve.getParamName(), param)).collect(Collectors.toSet());
    }

    public ValidationError getValidationError(String param) {
        this.consumed = true;
        return this.validationErrors.stream().filter(ve -> Objects.equals(ve.getParamName(), param)).findFirst().orElse(null);
    }

    public void addValidationErrors(Set<ValidationError> validationErrors) {
        this.validationErrors.addAll(validationErrors);
    }

    public void addBindingError(BindingError bindingError) {
        this.bindingErrors.add(bindingError);
    }

    public boolean hasUnconsumedErrors() {
        return !this.consumed && (!this.bindingErrors.isEmpty() || !this.validationErrors.isEmpty());
    }
}

